/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.DataServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class SNDCPDataChannelAnnouncementExplicit
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] SERVICE_OPTIONS = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int AUTONOMOUS_ACCESS_FLAG = 16;
    private static final int REQUESTED_ACCESS_FLAG = 17;
    private static final int[] TRANSMIT_FREQUENCY_BAND = new int[]{24, 25, 26, 27};
    private static final int[] TRANSMIT_CHANNEL_NUMBER = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] RECEIVE_FREQUENCY_BAND = new int[]{40, 41, 42, 43};
    private static final int[] RECEIVE_CHANNEL_NUMBER = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] DATA_ACCESS_CONTROL = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private List<Identifier> mIdentifiers;
    private APCO25Channel mChannel;
    private TalkgroupIdentifier mTargetAddress;
    private DataServiceOptions mServiceOptions;

    public SNDCPDataChannelAnnouncementExplicit(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" CHAN:").append(this.getChannel());
        if (this.isAutonomousAccess() && this.isRequestedAccess()) {
            sb.append(" AUTONOMOUS/REQUESTED-ACCESS");
        } else if (this.isAutonomousAccess()) {
            sb.append(" AUTONOMOUS-ACCESS");
        } else if (this.isRequestedAccess()) {
            sb.append(" REQUESTED-ACCESS");
        }
        sb.append(" DAC:").append(this.getDataAccessControl());
        sb.append(" ").append(this.getServiceOptions());
        return sb.toString();
    }

    public boolean isAutonomousAccess() {
        return this.getMessage().get(16 + this.getOffset());
    }

    public boolean isRequestedAccess() {
        return this.getMessage().get(17 + this.getOffset());
    }

    public DataServiceOptions getServiceOptions() {
        if (this.mServiceOptions == null) {
            this.mServiceOptions = new DataServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS, this.getOffset()));
        }
        return this.mServiceOptions;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = this.isExplicitChannel() ? APCO25ExplicitChannel.create(this.getMessage().getInt(TRANSMIT_FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(TRANSMIT_CHANNEL_NUMBER, this.getOffset()), this.getMessage().getInt(RECEIVE_FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(RECEIVE_CHANNEL_NUMBER, this.getOffset())) : APCO25Channel.create(this.getMessage().getInt(TRANSMIT_FREQUENCY_BAND, this.getOffset()), this.getMessage().getInt(TRANSMIT_CHANNEL_NUMBER, this.getOffset()));
        }
        return this.mChannel;
    }

    private boolean isExplicitChannel() {
        return this.getMessage().getInt(RECEIVE_CHANNEL_NUMBER, this.getOffset()) != 4095;
    }

    public int getDataAccessControl() {
        return this.getMessage().getInt(DATA_ACCESS_CONTROL, this.getOffset());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getChannel());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

