/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.Encryption;
import java.util.ArrayList;
import java.util.List;

public class RadioUnitMonitorCommandEnhanced
extends MacStructure {
    private static final int[] TARGET_ADDRESS = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] TALKGROUP_ID = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SOURCE_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int SM = 72;
    private static final int TG = 73;
    private static final int[] TRANSMIT_TIME = new int[]{80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] KEY_ID = new int[]{88, 89, 90, 91, 92, 93, 94, 95};
    private static final int[] ALGORITHM_ID = new int[]{96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress;
    private Identifier mTalkgroupId;
    private Identifier mSourceAddress;

    public RadioUnitMonitorCommandEnhanced(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        Encryption encryption;
        long transmitTime;
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" CALL RADIO:").append(this.getSourceAddress());
        sb.append(" OR TALKGROUP:").append(this.getTalkgroupId());
        if (this.isStealthMode()) {
            sb.append(" STEALTH MODE");
        }
        if (this.isTG()) {
            sb.append(" ?TG?");
        }
        if ((transmitTime = this.getTransmitTime()) > 0L) {
            sb.append(" TRANSMIT TIME:").append((double)transmitTime / 1000.0).append("secs");
        }
        if ((encryption = this.getEncryption()) != Encryption.UNENCRYPTED) {
            sb.append(" USE ENCRYPTION:").append((Object)encryption);
            sb.append(" KEY:").append(this.getEncryptionKeyId());
        }
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public Identifier getTalkgroupId() {
        if (this.mTalkgroupId == null) {
            this.mTalkgroupId = APCO25Talkgroup.create(this.getMessage().getInt(TALKGROUP_ID, this.getOffset()));
        }
        return this.mTalkgroupId;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceAddress;
    }

    public boolean isStealthMode() {
        return this.getMessage().get(72 + this.getOffset());
    }

    public boolean isTG() {
        return this.getMessage().get(73 + this.getOffset());
    }

    public long getTransmitTime() {
        return this.getMessage().getInt(TRANSMIT_TIME, this.getOffset()) * 100;
    }

    public int getEncryptionKeyId() {
        return this.getMessage().getInt(KEY_ID, this.getOffset());
    }

    public Encryption getEncryption() {
        return Encryption.fromValue(this.getMessage().getInt(ALGORITHM_ID, this.getOffset()));
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceAddress());
            this.mIdentifiers.add(this.getTalkgroupId());
        }
        return this.mIdentifiers;
    }
}

