/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25FullyQualifiedRadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class GroupAffiliationQueryExtended
extends MacStructure {
    private static final int[] TARGET_ADDRESS = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] SOURCE_WACN = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    private static final int[] SOURCE_SYSTEM = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SOURCE_ADDRESS = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private List<Identifier> mIdentifiers;
    private Identifier mTargetAddress;
    private Identifier mSourceSuid;

    public GroupAffiliationQueryExtended(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" FM:").append(this.getSourceSuid());
        sb.append(" TO:").append(this.getTargetAddress());
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public Identifier getSourceSuid() {
        if (this.mSourceSuid == null) {
            this.mSourceSuid = APCO25FullyQualifiedRadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_WACN, this.getOffset()), this.getMessage().getInt(SOURCE_SYSTEM, this.getOffset()), this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceSuid;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceSuid());
        }
        return this.mIdentifiers;
    }
}

