/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.ChannelType;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.util.FastMath;

public class FrequencyBandUpdateTDMA
extends MacStructure
implements IFrequencyBand {
    private static final int[] FREQUENCY_BAND_IDENTIFIER = new int[]{8, 9, 10, 11};
    private static final int[] CHANNEL_TYPE = new int[]{12, 13, 14, 15};
    private static final int TRANSMIT_OFFSET_SIGN = 16;
    private static final int[] TRANSMIT_OFFSET = new int[]{17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29};
    private static final int[] CHANNEL_SPACING = new int[]{30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] BASE_FREQUENCY = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private ChannelType mChannelType;

    public FrequencyBandUpdateTDMA(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" ID:").append(this.getIdentifier());
        sb.append(" OFFSET:").append(this.getTransmitOffset());
        sb.append(" SPACING:").append(this.getChannelSpacing());
        sb.append(" BASE:").append(this.getBaseFrequency());
        sb.append(" ").append((Object)this.getChannelType());
        return sb.toString();
    }

    public ChannelType getChannelType() {
        if (this.mChannelType == null) {
            this.mChannelType = ChannelType.fromValue(this.getMessage().getInt(CHANNEL_TYPE, this.getOffset()));
        }
        return this.mChannelType;
    }

    @Override
    public int getIdentifier() {
        return this.getMessage().getInt(FREQUENCY_BAND_IDENTIFIER, this.getOffset());
    }

    @Override
    public long getChannelSpacing() {
        return this.getMessage().getInt(CHANNEL_SPACING, this.getOffset()) * 125;
    }

    @Override
    public long getBaseFrequency() {
        return this.getMessage().getLong(BASE_FREQUENCY, this.getOffset()) * 5L;
    }

    @Override
    public int getBandwidth() {
        return this.getChannelType().getBandwidth();
    }

    @Override
    public long getTransmitOffset() {
        long offset = this.getMessage().getLong(TRANSMIT_OFFSET, this.getOffset()) * (long)this.getChannelType().getBandwidth();
        if (!this.getMessage().get(16 + this.getOffset())) {
            offset *= -1L;
        }
        return offset;
    }

    public boolean hasTransmitOffset() {
        return this.getMessage().getInt(TRANSMIT_OFFSET, this.getOffset()) != 128;
    }

    @Override
    public long getDownlinkFrequency(int channelNumber) {
        return this.getBaseFrequency() + this.getChannelSpacing() * (long)((int)FastMath.floor((double)(channelNumber / this.getTimeslotCount())));
    }

    @Override
    public long getUplinkFrequency(int channelNumber) {
        if (this.hasTransmitOffset()) {
            return this.getDownlinkFrequency(channelNumber) + this.getTransmitOffset();
        }
        return 0L;
    }

    @Override
    public boolean isTDMA() {
        return this.getChannelType().isTDMA();
    }

    @Override
    public int getTimeslotCount() {
        return this.getChannelType().getSlotsPerCarrier();
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

