/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.ExtendedFunction;
import java.util.ArrayList;
import java.util.List;

public class ExtendedFunctionCommand
extends MacStructure {
    private static final int[] FUNCTION = new int[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] ARGUMENTS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] TARGET_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private ExtendedFunction mExtendedFunction;
    private String mArguments;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public ExtendedFunctionCommand(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" FUNCTION:").append((Object)this.getExtendedFunction());
        sb.append(" ARGUMENTS:").append(this.getArguments());
        return sb.toString();
    }

    public ExtendedFunction getExtendedFunction() {
        if (this.mExtendedFunction == null) {
            this.mExtendedFunction = ExtendedFunction.fromValue(this.getMessage().getInt(FUNCTION, this.getOffset()));
        }
        return this.mExtendedFunction;
    }

    public String getArguments() {
        if (this.mArguments == null) {
            int arguments = this.getMessage().getInt(ARGUMENTS, this.getOffset());
            this.mArguments = Integer.toHexString(arguments).toUpperCase();
        }
        return this.mArguments;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
        }
        return this.mIdentifiers;
    }
}

