/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.P25P2Message;
import java.util.function.Function;

public class P25P2OtherMessageFilter
extends Filter<IMessage, String> {
    private static final String OTHER_KEY = "Other/Unknown Message";
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public P25P2OtherMessageFilter() {
        super("Other P25 messages");
        this.add(new FilterElement<String>(OTHER_KEY));
    }

    @Override
    public Function<IMessage, String> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof P25P2Message && super.canProcess(message);
    }

    private class KeyExtractor
    implements Function<IMessage, String> {
        private KeyExtractor(P25P2OtherMessageFilter p25P2OtherMessageFilter) {
        }

        @Override
        public String apply(IMessage message) {
            if (message instanceof P25P2Message) {
                return P25P2OtherMessageFilter.OTHER_KEY;
            }
            return null;
        }
    }
}

