/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.SyncLossMessage;
import io.github.dsheirer.module.decode.p25.phase2.DibitDelayBuffer;
import io.github.dsheirer.module.decode.p25.phase2.P25P2SyncDetector;
import io.github.dsheirer.module.decode.p25.phase2.P25P2SyncPattern;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.module.decode.p25.phase2.message.SuperFrameFragment;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacOpcode;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.NetworkStatusBroadcastAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.NetworkStatusBroadcastExtended;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractSignalingTimeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.ScramblingSequence;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Timeslot;
import io.github.dsheirer.protocol.Protocol;
import io.github.dsheirer.sample.Listener;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2SuperFrameDetector
implements Listener<Dibit>,
ISyncDetectListener {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2SuperFrameDetector.class);
    private static final int FRAGMENT_DIBIT_LENGTH = 720;
    private static final int DIBIT_COUNT_MISALIGNED_SYNC = 540;
    private static final int BROADCAST_SYNC_LOSS_DIBIT_COUNT = 3720;
    private static final int DIBIT_DELAY_BUFFER_INDEX_SYNC_1 = 360;
    private static final int DIBIT_DELAY_BUFFER_INDEX_SYNC_2 = 540;
    private static final int SYNCHRONIZED_SYNC_MATCH_THRESHOLD = 10;
    private static final int UN_SYNCHRONIZED_SYNC_MATCH_THRESHOLD = 4;
    private ScramblingSequence mScramblingSequence = new ScramblingSequence();
    private Listener<IMessage> mMessageListener;
    private P25P2SyncDetector mSyncDetector;
    private DibitDelayBuffer mSyncDetectionDelayBuffer = new DibitDelayBuffer(160);
    private DibitDelayBuffer mFragmentBuffer = new DibitDelayBuffer(720);
    private int mDibitsProcessed = 0;
    private boolean mSynchronized = false;
    private ISyncDetectListener mSyncDetectListener;

    public P25P2SuperFrameDetector(IPhaseLockedLoop phaseLockedLoop) {
        this.mSyncDetector = new P25P2SyncDetector(this, phaseLockedLoop);
    }

    public void setScrambleParameters(ScrambleParameters scramblingSequence) {
        this.mScramblingSequence.update(scramblingSequence);
    }

    public void setSyncDetectListener(ISyncDetectListener listener) {
        this.mSyncDetectListener = listener;
    }

    public void setListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void setSampleRate(double sampleRate) {
        this.mSyncDetector.setSampleRate(sampleRate);
    }

    public void reset() {
    }

    @Override
    public void syncDetected(int bitErrors) {
        this.checkFragmentSync(bitErrors);
        if (this.mSyncDetectListener != null) {
            this.mSyncDetectListener.syncDetected(bitErrors);
        }
    }

    @Override
    public void syncLost(int bitsProcessed) {
        if (this.mSyncDetectListener != null) {
            this.mSyncDetectListener.syncLost(bitsProcessed);
        }
    }

    private long getCurrentTimestamp() {
        return System.currentTimeMillis();
    }

    @Override
    public void receive(Dibit dibit) {
        ++this.mDibitsProcessed;
        this.mFragmentBuffer.put(dibit);
        if (this.mSynchronized) {
            this.mSyncDetectionDelayBuffer.put(dibit);
            if (this.mDibitsProcessed >= 720) {
                this.checkFragmentSync(0);
            }
        } else {
            Dibit delayed = this.mSyncDetectionDelayBuffer.getAndPut(dibit);
            this.mSyncDetector.receive(delayed);
        }
        if (this.mDibitsProcessed > 3720) {
            this.mDibitsProcessed -= 3000;
            this.broadcastSyncLoss(3000);
        }
    }

    private void broadcastFragment(int bitErrors) {
        if (this.mDibitsProcessed > 720) {
            this.broadcastSyncLoss(this.mDibitsProcessed - 720);
        }
        this.mDibitsProcessed = 0;
        CorrectedBinaryMessage message = this.mFragmentBuffer.getMessage(0, 720);
        message.setCorrectedBitCount(bitErrors);
        SuperFrameFragment frameFragment = new SuperFrameFragment(message, this.getCurrentTimestamp(), this.mScramblingSequence);
        this.updateScramblingCode(frameFragment);
        this.broadcast(frameFragment);
    }

    private void updateScramblingCode(SuperFrameFragment superFrameFragment) {
        for (Timeslot timeslot : superFrameFragment.getTimeslots()) {
            if (!(timeslot instanceof AbstractSignalingTimeslot)) continue;
            List<MacMessage> macMessages = ((AbstractSignalingTimeslot)timeslot).getMacMessages();
            for (MacMessage macMessage : macMessages) {
                MacStructure networkStatus;
                MacOpcode macOpcode = macMessage.getMacStructure().getOpcode();
                if (macOpcode == MacOpcode.PHASE1_123_NETWORK_STATUS_BROADCAST_ABBREVIATED && macMessage.getMacStructure() instanceof NetworkStatusBroadcastAbbreviated) {
                    networkStatus = (NetworkStatusBroadcastAbbreviated)macMessage.getMacStructure();
                    this.mScramblingSequence.update(((NetworkStatusBroadcastAbbreviated)networkStatus).getScrambleParameters());
                    continue;
                }
                if (macOpcode != MacOpcode.PHASE1_251_NETWORK_STATUS_BROADCAST_EXTENDED || !(macMessage.getMacStructure() instanceof NetworkStatusBroadcastExtended)) continue;
                networkStatus = (NetworkStatusBroadcastExtended)macMessage.getMacStructure();
                this.mScramblingSequence.update(((NetworkStatusBroadcastExtended)networkStatus).getScrambleParameters());
            }
        }
    }

    private void broadcastSyncLoss(int dibitsProcessed) {
        this.broadcast(new SyncLossMessage(this.getCurrentTimestamp(), dibitsProcessed * 2, Protocol.APCO25_PHASE2));
    }

    private void broadcast(IMessage message) {
        if (this.mMessageListener != null) {
            this.mMessageListener.receive(message);
        }
    }

    private void checkFragmentSync(int syncDetectorBitErrorCount) {
        if (this.mDibitsProcessed > 0) {
            if (this.mSynchronized) {
                Dibit[] sync1Dibits = this.mFragmentBuffer.getBuffer(360, 20);
                int sync1BitErrorCount = P25P2SyncPattern.getBitErrorCount(sync1Dibits);
                if (sync1BitErrorCount <= 10) {
                    Dibit[] sync2Dibits = this.mFragmentBuffer.getBuffer(540, 20);
                    int sync2BitErrorCount = P25P2SyncPattern.getBitErrorCount(sync2Dibits);
                    if (sync2BitErrorCount <= 10) {
                        this.broadcastFragment(sync1BitErrorCount + sync2BitErrorCount);
                        this.syncDetected(sync1BitErrorCount + sync2BitErrorCount);
                        return;
                    }
                    this.mSynchronized = false;
                    return;
                }
                this.mSynchronized = false;
                return;
            }
            Dibit[] sync1Dibits = this.mFragmentBuffer.getBuffer(360, 20);
            int sync1BitErrorCount = P25P2SyncPattern.getBitErrorCount(sync1Dibits);
            if (sync1BitErrorCount <= 4) {
                this.mSynchronized = true;
                this.broadcastFragment(sync1BitErrorCount + syncDetectorBitErrorCount);
            } else {
                this.mSynchronized = true;
                if (this.mDibitsProcessed > 540) {
                    this.broadcastSyncLoss(this.mDibitsProcessed - 540);
                }
                this.mDibitsProcessed = 540;
            }
        }
    }
}

