/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.SyncLossMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.EncryptionSynchronizationSequenceProcessor;
import io.github.dsheirer.module.decode.p25.phase2.message.SuperFrameFragment;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessage;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractSignalingTimeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractVoiceTimeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Timeslot;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.Voice2Timeslot;
import io.github.dsheirer.sample.Listener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2MessageProcessor
implements Listener<IMessage> {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2MessageProcessor.class);
    private EncryptionSynchronizationSequenceProcessor mESSProcessor0 = new EncryptionSynchronizationSequenceProcessor(0);
    private EncryptionSynchronizationSequenceProcessor mESSProcessor1 = new EncryptionSynchronizationSequenceProcessor(1);
    private Listener<IMessage> mMessageListener;
    private Map<Integer, IFrequencyBand> mFrequencyBandMap = new TreeMap<Integer, IFrequencyBand>();

    @Override
    public void receive(IMessage message) {
        if (this.mMessageListener != null) {
            if (message instanceof SuperFrameFragment) {
                SuperFrameFragment sff = (SuperFrameFragment)message;
                for (Timeslot timeslot : sff.getTimeslots()) {
                    if (timeslot instanceof AbstractSignalingTimeslot) {
                        AbstractSignalingTimeslot ast = (AbstractSignalingTimeslot)timeslot;
                        for (MacMessage macMessage : ast.getMacMessages()) {
                            if (macMessage instanceof IFrequencyBandReceiver) {
                                IFrequencyBandReceiver receiver = (IFrequencyBandReceiver)((Object)macMessage);
                                List<IChannelDescriptor> channels = receiver.getChannels();
                                for (IChannelDescriptor channel : channels) {
                                    int[] frequencyBandIdentifiers;
                                    for (int id : frequencyBandIdentifiers = channel.getFrequencyBandIdentifiers()) {
                                        if (!this.mFrequencyBandMap.containsKey(id)) continue;
                                        channel.setFrequencyBand(this.mFrequencyBandMap.get(id));
                                    }
                                }
                            }
                            if (macMessage instanceof IFrequencyBand) {
                                IFrequencyBand bandIdentifier = (IFrequencyBand)((Object)macMessage);
                                this.mFrequencyBandMap.put(bandIdentifier.getIdentifier(), bandIdentifier);
                            }
                            this.mMessageListener.receive(macMessage);
                        }
                        continue;
                    }
                    if (timeslot instanceof AbstractVoiceTimeslot) {
                        if (timeslot.getTimeslot() == 0) {
                            this.mESSProcessor0.process((AbstractVoiceTimeslot)timeslot);
                            if (timeslot instanceof Voice2Timeslot) {
                                ess = this.mESSProcessor0.getSequence();
                                if (ess != null) {
                                    this.mMessageListener.receive(ess);
                                }
                                this.mESSProcessor0.reset();
                            }
                        } else {
                            this.mESSProcessor1.process((AbstractVoiceTimeslot)timeslot);
                            if (timeslot instanceof Voice2Timeslot) {
                                ess = this.mESSProcessor1.getSequence();
                                if (ess != null) {
                                    this.mMessageListener.receive(ess);
                                }
                                this.mESSProcessor1.reset();
                            }
                        }
                        this.mMessageListener.receive(timeslot);
                        continue;
                    }
                    this.mMessageListener.receive(timeslot);
                }
            } else if (message instanceof SyncLossMessage) {
                this.mMessageListener.receive(message);
            }
        }
    }

    public void dispose() {
        this.mMessageListener = null;
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }
}

