/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2;

import io.github.dsheirer.dsp.psk.DQPSKGardnerDemodulatorInstrumented;
import io.github.dsheirer.dsp.psk.InterpolatingSampleBufferInstrumented;
import io.github.dsheirer.dsp.psk.SymbolDecisionData;
import io.github.dsheirer.module.decode.p25.phase2.DecodeConfigP25Phase2;
import io.github.dsheirer.module.decode.p25.phase2.P25P2DecoderHDQPSK;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSamples;

public class P25P2DecoderHDQPSKInstrumented
extends P25P2DecoderHDQPSK {
    private Listener<Double> mPLLPhaseErrorListener;
    private Listener<Double> mPLLFrequencyListener;
    private Listener<Double> mSamplesPerSymbolListener;
    private Listener<Complex> mComplexSymbolListener;
    private Listener<ComplexSamples> mFilteredSymbolListener;
    private Listener<SymbolDecisionData> mSymbolDecisionDataListener;

    public P25P2DecoderHDQPSKInstrumented(DecodeConfigP25Phase2 decodeConfigP25Phase2) {
        super(decodeConfigP25Phase2);
    }

    public DQPSKGardnerDemodulatorInstrumented getDemodulator() {
        return (DQPSKGardnerDemodulatorInstrumented)this.mQPSKDemodulator;
    }

    @Override
    public void receive(ComplexSamples samples) {
        this.mMessageFramer.setCurrentTime(System.currentTimeMillis());
        float[] i = this.mIBasebandFilter.filter(samples.i());
        float[] q = this.mQBasebandFilter.filter(samples.q());
        if (this.mFilteredSymbolListener != null) {
            this.mFilteredSymbolListener.receive(samples);
        }
        this.mPowerMonitor.process(i, q);
        ComplexSamples amplified = this.mAGC.process(i, q, samples.timestamp());
        this.mQPSKDemodulator.receive(amplified);
    }

    public InterpolatingSampleBufferInstrumented getSampleBuffer() {
        return (InterpolatingSampleBufferInstrumented)this.mInterpolatingSampleBuffer;
    }

    @Override
    public void setSampleRate(double sampleRate) {
        super.setSampleRate(sampleRate);
        InterpolatingSampleBufferInstrumented instrumentedBuffer = new InterpolatingSampleBufferInstrumented(this.getSamplesPerSymbol(), 0.1f);
        this.mInterpolatingSampleBuffer = instrumentedBuffer;
        DQPSKGardnerDemodulatorInstrumented instrumented = new DQPSKGardnerDemodulatorInstrumented(this.mCostasLoop, instrumentedBuffer, this.getSampleRate());
        this.mQPSKDemodulator = instrumented;
        instrumented.setComplexSymbolListener(this.mComplexSymbolListener);
        instrumented.setPLLErrorListener(this.mPLLPhaseErrorListener);
        instrumented.setPLLFrequencyListener(this.mPLLFrequencyListener);
        instrumented.setSymbolDecisionDataListener(this.mSymbolDecisionDataListener);
        instrumented.setSamplesPerSymbolListener(this.mSamplesPerSymbolListener);
        instrumented.setSymbolListener(this.getDibitBroadcaster());
        this.getDibitBroadcaster().addListener(this.mMessageFramer);
    }

    public void setComplexSymbolListener(Listener<Complex> listener) {
        this.mComplexSymbolListener = listener;
        this.getDemodulator().setComplexSymbolListener(listener);
    }

    public void setPLLPhaseErrorListener(Listener<Double> listener) {
        this.mPLLPhaseErrorListener = listener;
        this.getDemodulator().setPLLErrorListener(listener);
    }

    public void setPLLFrequencyListener(Listener<Double> listener) {
        this.mPLLFrequencyListener = listener;
        this.getDemodulator().setPLLFrequencyListener(listener);
    }

    public void setFilteredBufferListener(Listener<ComplexSamples> listener) {
        this.mFilteredSymbolListener = listener;
    }

    public void setSymbolDecisionDataListener(Listener<SymbolDecisionData> listener) {
        this.mSymbolDecisionDataListener = listener;
        this.getDemodulator().setSymbolDecisionDataListener(listener);
    }

    public void setSamplesPerSymbolListener(Listener<Double> listener) {
        this.mSamplesPerSymbolListener = listener;
        this.getDemodulator().setSamplesPerSymbolListener(listener);
    }
}

