/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class TelephoneInterconnectVoiceChannelGrantUpdate
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] FREQUENCY_BAND = new int[]{24, 25, 26, 27};
    private static final int[] CHANNEL_NUMBER = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] CALL_TIMER = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] ANY_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private VoiceServiceOptions mVoiceServiceOptions;
    private APCO25Channel mChannel;
    private Identifier mAnyAddress;
    private List<Identifier> mIdentifiers;

    public TelephoneInterconnectVoiceChannelGrantUpdate(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" RADIO:").append(this.getAnyAddress());
        sb.append(" TIMER:").append(this.getCallTimer());
        sb.append("ms CHAN:").append(this.getChannel());
        sb.append(" ").append(this.getVoiceServiceOptions().toString());
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions == null) {
            this.mVoiceServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS));
        }
        return this.mVoiceServiceOptions;
    }

    public long getCallTimer() {
        return (long)this.getMessage().getInt(CALL_TIMER) * 100L;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND), this.getMessage().getInt(CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public Identifier getAnyAddress() {
        if (this.mAnyAddress == null) {
            this.mAnyAddress = APCO25Talkgroup.create(this.getMessage().getInt(ANY_ADDRESS));
        }
        return this.mAnyAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getAnyAddress());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

