/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.telephone.APCO25TelephoneNumber;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.Digit;
import java.util.ArrayList;
import java.util.List;

public class TelephoneInterconnectAnswerRequest
extends OSPMessage {
    private static final int[] DIGIT_1 = new int[]{16, 17, 18, 19};
    private static final int[] DIGIT_2 = new int[]{20, 21, 22, 23};
    private static final int[] DIGIT_3 = new int[]{24, 25, 26, 27};
    private static final int[] DIGIT_4 = new int[]{28, 29, 30, 31};
    private static final int[] DIGIT_5 = new int[]{32, 33, 34, 35};
    private static final int[] DIGIT_6 = new int[]{36, 37, 38, 39};
    private static final int[] DIGIT_7 = new int[]{40, 41, 42, 43};
    private static final int[] DIGIT_8 = new int[]{44, 45, 46, 47};
    private static final int[] DIGIT_9 = new int[]{48, 49, 50, 51};
    private static final int[] DIGIT_10 = new int[]{52, 53, 54, 55};
    private static final int[] TARGET_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mTelephoneNumber;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public TelephoneInterconnectAnswerRequest(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" FM:").append(this.getTelephoneNumber());
        sb.append(" TO:").append(this.getTargetAddress());
        return sb.toString();
    }

    public Identifier getTelephoneNumber() {
        if (this.mTelephoneNumber == null) {
            ArrayList<Integer> digits = new ArrayList<Integer>();
            digits.add(this.getMessage().getInt(DIGIT_1));
            digits.add(this.getMessage().getInt(DIGIT_2));
            digits.add(this.getMessage().getInt(DIGIT_3));
            digits.add(this.getMessage().getInt(DIGIT_4));
            digits.add(this.getMessage().getInt(DIGIT_5));
            digits.add(this.getMessage().getInt(DIGIT_6));
            digits.add(this.getMessage().getInt(DIGIT_7));
            digits.add(this.getMessage().getInt(DIGIT_8));
            digits.add(this.getMessage().getInt(DIGIT_9));
            digits.add(this.getMessage().getInt(DIGIT_10));
            this.mTelephoneNumber = APCO25TelephoneNumber.createFrom(Digit.decode(digits));
        }
        return this.mTelephoneNumber;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getTelephoneNumber());
        }
        return this.mIdentifiers;
    }
}

