/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Lra;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class NetworkStatusBroadcast
extends OSPMessage
implements IFrequencyBandReceiver {
    private static final int[] LOCATION_REGISTRATION_AREA = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] WACN = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43};
    private static final int[] SYSTEM = new int[]{44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] FREQUENCY_BAND = new int[]{56, 57, 58, 59};
    private static final int[] CHANNEL_NUMBER = new int[]{60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private static final int[] SYSTEM_SERVICE_CLASS = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mLocationRegistrationArea;
    private Identifier mWacn;
    private Identifier mSystem;
    private IChannelDescriptor mChannel;
    private SystemServiceClass mSystemServiceClass;
    private List<Identifier> mIdentifiers;
    private List<String> mSiteFlags;
    private ScrambleParameters mScrambleParameters;

    public NetworkStatusBroadcast(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" WACN:").append(this.getWacn());
        sb.append(" SYSTEM:").append(this.getSystem());
        sb.append(" LRA:").append(this.getLocationRegistrationArea());
        sb.append(" SERVICES:").append(this.getSystemServiceClass().getServices());
        return sb.toString();
    }

    public ScrambleParameters getScrambleParameters() {
        if (this.mScrambleParameters == null) {
            this.mScrambleParameters = new ScrambleParameters((Integer)this.getWacn().getValue(), (Integer)this.getSystem().getValue(), (Integer)this.getNAC().getValue());
        }
        return this.mScrambleParameters;
    }

    public Identifier getLocationRegistrationArea() {
        if (this.mLocationRegistrationArea == null) {
            this.mLocationRegistrationArea = APCO25Lra.create(this.getMessage().getInt(LOCATION_REGISTRATION_AREA));
        }
        return this.mLocationRegistrationArea;
    }

    public Identifier getWacn() {
        if (this.mWacn == null) {
            this.mWacn = APCO25Wacn.create(this.getMessage().getInt(WACN));
        }
        return this.mWacn;
    }

    public Identifier getSystem() {
        if (this.mSystem == null) {
            this.mSystem = APCO25System.create(this.getMessage().getInt(SYSTEM));
        }
        return this.mSystem;
    }

    public IChannelDescriptor getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND), this.getMessage().getInt(CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    public SystemServiceClass getSystemServiceClass() {
        if (this.mSystemServiceClass == null) {
            this.mSystemServiceClass = SystemServiceClass.create(this.getMessage().getInt(SYSTEM_SERVICE_CLASS));
        }
        return this.mSystemServiceClass;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getLocationRegistrationArea());
            this.mIdentifiers.add(this.getWacn());
            this.mIdentifiers.add(this.getSystem());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }
}

