/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.isp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.ISPMessage;
import java.util.ArrayList;
import java.util.List;

public class FrequencyBandUpdateRequest
extends ISPMessage {
    private static final int REBROADCAST_ALL_FREQUENCY_BANDS_FLAG = 16;
    private static final int[] RESERVED_FLAGS = new int[]{17, 18, 19};
    private static final int[] FREQUENCY_BAND = new int[]{20, 21, 22, 23};
    private static final int[] RESERVED = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private Identifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public FrequencyBandUpdateRequest(P25P1DataUnitID dataUnitId, CorrectedBinaryMessage message, int nac, long timestamp) {
        super(dataUnitId, message, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" FM:").append(this.getSourceAddress());
        if (this.isAllFrequencyBands()) {
            sb.append(" REBROADCAST ALL FREQUENCY BANDS");
        } else {
            sb.append(" REBROADCAST FREQUENCY BAND:").append(this.getFrequencyBand());
        }
        return sb.toString();
    }

    public boolean isAllFrequencyBands() {
        return this.getMessage().get(16);
    }

    public int getFrequencyBand() {
        return this.getMessage().getInt(FREQUENCY_BAND);
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceAddress());
        }
        return this.mIdentifiers;
    }
}

