/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.patch.PatchGroupIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.OSPMessage;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class PatchGroupVoiceChannelGrant
extends OSPMessage
implements IFrequencyBandReceiver {
    public static final int[] SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    public static final int[] FREQUENCY_BAND = new int[]{24, 25, 26, 27};
    public static final int[] CHANNEL_NUMBER = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    public static final int[] PATCH_GROUP_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    public static final int[] SOURCE_ADDRESS = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private VoiceServiceOptions mVoiceServiceOptions;
    private APCO25Channel mChannel;
    private Identifier mSourceAddress;
    private PatchGroupIdentifier mPatchGroup;
    private List<Identifier> mIdentifiers;

    public PatchGroupVoiceChannelGrant(P25P1DataUnitID dataUnitID, CorrectedBinaryMessage message, int nac, long timestlot) {
        super(dataUnitID, message, nac, timestlot);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" PATCH GROUP:").append(this.getPatchGroup());
        sb.append(" FROM:").append(this.getSourceAddress());
        sb.append(" SERVICE OPTIONS:").append(this.getVoiceServiceOptions());
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions == null) {
            this.mVoiceServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS));
        }
        return this.mVoiceServiceOptions;
    }

    public PatchGroupIdentifier getPatchGroup() {
        if (this.mPatchGroup == null) {
            this.mPatchGroup = APCO25PatchGroup.create(new PatchGroup(APCO25Talkgroup.create(this.getMessage().getInt(PATCH_GROUP_ADDRESS))));
        }
        return this.mPatchGroup;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceAddress;
    }

    public APCO25Channel getChannel() {
        if (this.mChannel == null) {
            this.mChannel = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND), this.getMessage().getInt(CHANNEL_NUMBER));
        }
        return this.mChannel;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannel());
        return channels;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPatchGroup());
            this.mIdentifiers.add(this.getSourceAddress());
        }
        return this.mIdentifiers;
    }
}

