/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.tdu;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.edac.Golay24;
import io.github.dsheirer.edac.ReedSolomon_24_12_13_P25;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWordFactory;
import java.util.Collections;
import java.util.List;

public class TDULinkControlMessage
extends P25Message
implements IFrequencyBandReceiver {
    public static final int[] LC_HEX_0 = new int[]{0, 1, 2, 3, 4, 5};
    public static final int[] LC_HEX_1 = new int[]{6, 7, 8, 9, 10, 11};
    public static final int[] LC_HEX_2 = new int[]{24, 25, 26, 27, 28, 29};
    public static final int[] LC_HEX_3 = new int[]{30, 31, 32, 33, 34, 35};
    public static final int[] LC_HEX_4 = new int[]{48, 49, 50, 51, 52, 53};
    public static final int[] LC_HEX_5 = new int[]{54, 55, 56, 57, 58, 59};
    public static final int[] LC_HEX_6 = new int[]{72, 73, 74, 75, 76, 77};
    public static final int[] LC_HEX_7 = new int[]{78, 79, 80, 81, 82, 83};
    public static final int[] LC_HEX_8 = new int[]{96, 97, 98, 99, 100, 101};
    public static final int[] LC_HEX_9 = new int[]{102, 103, 104, 105, 106, 107};
    public static final int[] LC_HEX_10 = new int[]{120, 121, 122, 123, 124, 125};
    public static final int[] LC_HEX_11 = new int[]{126, 127, 128, 129, 130, 131};
    public static final int[] RS_HEX_0 = new int[]{144, 145, 146, 147, 148, 149};
    public static final int[] RS_HEX_1 = new int[]{150, 151, 152, 153, 154, 155};
    public static final int[] RS_HEX_2 = new int[]{168, 169, 170, 171, 172, 173};
    public static final int[] RS_HEX_3 = new int[]{174, 175, 176, 177, 178, 179};
    public static final int[] RS_HEX_4 = new int[]{192, 193, 194, 195, 196, 197};
    public static final int[] RS_HEX_5 = new int[]{198, 199, 200, 201, 202, 203};
    public static final int[] RS_HEX_6 = new int[]{216, 217, 218, 219, 220, 221};
    public static final int[] RS_HEX_7 = new int[]{222, 223, 224, 225, 226, 227};
    public static final int[] RS_HEX_8 = new int[]{240, 241, 242, 243, 244, 245};
    public static final int[] RS_HEX_9 = new int[]{246, 247, 248, 249, 250, 251};
    public static final int[] RS_HEX_10 = new int[]{264, 265, 266, 267, 268, 269};
    public static final int[] RS_HEX_11 = new int[]{270, 271, 272, 273, 274, 275};
    private static final ReedSolomon_24_12_13_P25 REED_SOLOMON_24_12_13_P25 = new ReedSolomon_24_12_13_P25();
    private LinkControlWord mLinkControlWord;

    public TDULinkControlMessage(CorrectedBinaryMessage message, int nac, long timestamp) {
        super(message, nac, timestamp);
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return P25P1DataUnitID.TERMINATOR_DATA_UNIT_LINK_CONTROL;
    }

    public LinkControlWord getLinkControlWord() {
        if (this.mLinkControlWord == null) {
            this.createLinkControlWord();
        }
        return this.mLinkControlWord;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" ").append(this.getLinkControlWord());
        return sb.toString();
    }

    private void createLinkControlWord() {
        int x;
        for (int codewordPointer = 0; codewordPointer < this.getMessage().size(); codewordPointer += 24) {
            int corrected = Golay24.checkAndCorrect(this.getMessage(), codewordPointer);
        }
        int[] input = new int[63];
        int[] output = new int[63];
        input[0] = this.getMessage().getInt(RS_HEX_11);
        input[1] = this.getMessage().getInt(RS_HEX_10);
        input[2] = this.getMessage().getInt(RS_HEX_9);
        input[3] = this.getMessage().getInt(RS_HEX_8);
        input[4] = this.getMessage().getInt(RS_HEX_7);
        input[5] = this.getMessage().getInt(RS_HEX_6);
        input[6] = this.getMessage().getInt(RS_HEX_5);
        input[7] = this.getMessage().getInt(RS_HEX_4);
        input[8] = this.getMessage().getInt(RS_HEX_3);
        input[9] = this.getMessage().getInt(RS_HEX_2);
        input[10] = this.getMessage().getInt(RS_HEX_1);
        input[11] = this.getMessage().getInt(RS_HEX_0);
        input[12] = this.getMessage().getInt(LC_HEX_11);
        input[13] = this.getMessage().getInt(LC_HEX_10);
        input[14] = this.getMessage().getInt(LC_HEX_9);
        input[15] = this.getMessage().getInt(LC_HEX_8);
        input[16] = this.getMessage().getInt(LC_HEX_7);
        input[17] = this.getMessage().getInt(LC_HEX_6);
        input[18] = this.getMessage().getInt(LC_HEX_5);
        input[19] = this.getMessage().getInt(LC_HEX_4);
        input[20] = this.getMessage().getInt(LC_HEX_3);
        input[21] = this.getMessage().getInt(LC_HEX_2);
        input[22] = this.getMessage().getInt(LC_HEX_1);
        input[23] = this.getMessage().getInt(LC_HEX_0);
        boolean irrecoverableErrors = REED_SOLOMON_24_12_13_P25.decode(input, output);
        BinaryMessage binaryMessage = new BinaryMessage(72);
        int pointer = 0;
        for (x = 23; x >= 12; --x) {
            if (output[x] != -1) {
                binaryMessage.load(pointer, 6, output[x]);
            }
            pointer += 6;
        }
        this.mLinkControlWord = LinkControlWordFactory.create(binaryMessage);
        if (irrecoverableErrors) {
            this.mLinkControlWord.setValid(false);
        }
        for (x = 0; x < 23; ++x) {
            if (output[x] == input[x]) continue;
            this.getMessage().incrementCorrectedBitCount(Integer.bitCount(output[x] ^ input[x]));
        }
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        if (this.getLinkControlWord().isValid() && this.getLinkControlWord() instanceof IFrequencyBandReceiver) {
            return ((IFrequencyBandReceiver)((Object)this.getLinkControlWord())).getChannels();
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return this.getLinkControlWord().getIdentifiers();
    }
}

