/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.umbtc.isp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IBitErrorProvider;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.telephone.APCO25TelephoneNumber;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.umbtc.UMBTCMessage;
import io.github.dsheirer.module.decode.p25.reference.Digit;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class UMBTCTelephoneInterconnectRequestExplicitDialing
extends UMBTCMessage
implements IBitErrorProvider {
    private static final int[] BLOCK_0_DIGIT_COUNT = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private VoiceServiceOptions mVoiceServiceOptions;
    private Identifier mSourceAddress;
    private Identifier mTelephoneNumber;
    private List<Identifier> mIdentifiers;

    public UMBTCTelephoneInterconnectRequestExplicitDialing(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessageStub());
        sb.append(" FM:").append(this.getSourceAddress());
        if (this.getTelephoneNumber() != null) {
            sb.append(" TO:").append(this.getTelephoneNumber());
        }
        if (this.getVoiceServiceOptions() != null) {
            sb.append(" SERVICE OPTIONS:").append(this.getVoiceServiceOptions());
        }
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions != null || this.hasDataBlock(0)) {
            // empty if block
        }
        this.mVoiceServiceOptions = new VoiceServiceOptions(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SERVICE_OPTIONS));
        return this.mVoiceServiceOptions;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getHeader().getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mSourceAddress;
    }

    public Identifier getTelephoneNumber() {
        if (this.mTelephoneNumber == null && this.hasDataBlock(0)) {
            int digitCount = this.getDataBlock(0).getMessage().getInt(BLOCK_0_DIGIT_COUNT);
            ArrayList<Integer> digits = new ArrayList<Integer>();
            for (int x = 1; x <= digitCount; ++x) {
                digits.add(this.getDigit(x));
            }
            this.mTelephoneNumber = APCO25TelephoneNumber.createTo(Digit.decode(digits));
        }
        return this.mTelephoneNumber;
    }

    private int getDigit(int digit) {
        if (digit <= 18) {
            if (this.hasDataBlock(0)) {
                int startIndex = 24 + (digit - 1) * 4;
                return this.getDataBlock(0).getMessage().getInt(startIndex, startIndex + 3);
            }
        } else if (digit <= 34 && this.hasDataBlock(1)) {
            int startIndex = 0 + (digit - 19) * 4;
            return this.getDataBlock(0).getMessage().getInt(startIndex, startIndex + 3);
        }
        return -1;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSourceAddress());
            if (this.getTelephoneNumber() != null) {
                this.mIdentifiers.add(this.getTelephoneNumber());
            }
        }
        return this.mIdentifiers;
    }
}

