/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet.sndcp;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.module.decode.p25.reference.PDUType;

public class SNDCPMessage {
    private static final int[] PDU_TYPE = new int[]{0, 1, 2, 3};
    private BinaryMessage mMessage;
    private boolean mOutbound;

    public SNDCPMessage(BinaryMessage message, boolean outbound) {
        this.mMessage = message;
        this.mOutbound = outbound;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getPDUType());
        return sb.toString();
    }

    public BinaryMessage getMessage() {
        return this.mMessage;
    }

    public boolean isOutbound() {
        return this.mOutbound;
    }

    public PDUType getPDUType() {
        return SNDCPMessage.getPDUType(this.getMessage(), this.isOutbound());
    }

    public static PDUType getPDUType(BinaryMessage message, boolean outbound) {
        return PDUType.fromValue(message.getInt(PDU_TYPE), outbound);
    }
}

