/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.packet;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUHeader;
import io.github.dsheirer.module.decode.p25.reference.ServiceAccessPoint;

public class PacketHeader
extends PDUHeader {
    public static final int[] SAP_ID = new int[]{10, 11, 12, 13, 14, 15};
    public static final int FULL_MESSAGE_FLAG = 48;
    public static final int[] PAD_OCTET_COUNT = new int[]{59, 60, 61, 62, 63};
    public static final int SYNCHRONIZE_FLAG = 64;
    public static final int[] PACKET_SEQUENCE_NUMBER = new int[]{65, 66};
    public static final int[] MESSAGE_FRAGMENT_SEQUENCE_NUMBER = new int[]{67, 68, 69};
    public static final int[] DATA_HEADER_OFFSET = new int[]{74, 75, 76, 77, 78, 79};

    public PacketHeader(CorrectedBinaryMessage message, boolean passesCRC) {
        super(message, passesCRC);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append(" *CRC-FAIL*");
        }
        sb.append(this.isConfirmationRequired() ? " CONFIRMED" : " UNCONFIRMED");
        sb.append(" ").append((Object)this.getDirection());
        sb.append(" FMT:").append(this.getFormat().getLabel());
        sb.append(" SAP:").append(this.getServiceAccessPoint().name());
        sb.append(" VEND:").append(this.getVendor().getLabel());
        sb.append(this.isOutbound() ? "TO" : "FROM").append(" LLID:").append(this.getLLID());
        sb.append(" BLKS TO FOLLOW:").append(this.getBlocksToFollowCount());
        if (this.isSynchronize()) {
            sb.append(" PACKET:").append(this.getPacketSequenceNumber());
            sb.append(" MSG FRAGMENT:").append(this.getMessageFragmentSequenceNumber());
        }
        sb.append(" PAD OCTETS:").append(this.getPadOctetCount());
        sb.append(" HEADER OFFSET:").append(this.getDataHeaderOffset());
        return sb.toString();
    }

    public ServiceAccessPoint getServiceAccessPoint() {
        return ServiceAccessPoint.fromValue(this.getMessage().getInt(SAP_ID));
    }

    public boolean isFullMessage() {
        return this.getMessage().get(48);
    }

    public int getPadOctetCount() {
        return this.getMessage().getInt(PAD_OCTET_COUNT);
    }

    public boolean isSynchronize() {
        return this.getMessage().get(64);
    }

    public int getPacketSequenceNumber() {
        return this.getMessage().getInt(PACKET_SEQUENCE_NUMBER);
    }

    public int getMessageFragmentSequenceNumber() {
        return this.getMessage().getInt(MESSAGE_FRAGMENT_SEQUENCE_NUMBER);
    }

    public int getDataHeaderOffset() {
        return this.getMessage().getInt(DATA_HEADER_OFFSET);
    }
}

