/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25FullyQualifiedRadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.reference.Response;
import java.util.ArrayList;
import java.util.List;

public class AMBTCUnitRegistrationResponse
extends AMBTCMessage {
    private static final int[] HEADER_WACN = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_WACN = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_0_SYSTEM = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_SOURCE_ID = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] BLOCK_0_SOURCE_ADDRESS = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] BLOCK_0_RESPONSE = new int[]{70, 71};
    private Response mResponse;
    private Identifier mTargetAddress;
    private APCO25FullyQualifiedRadioIdentifier mFullyQualifiedTargetAddress;
    private Identifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public AMBTCUnitRegistrationResponse(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append("REGISTRATION ").append((Object)this.getResponse());
        if (this.getFullyQualifiedTargetAddress() != null) {
            sb.append(" TO:").append(this.getFullyQualifiedTargetAddress());
        }
        if (this.getTargetAddress() != null) {
            sb.append(" ALIASED AS:").append(this.getTargetAddress());
        }
        if (this.getSourceAddress() != null) {
            sb.append(" FROM:").append(this.getSourceAddress());
        }
        return sb.toString();
    }

    public Response getResponse() {
        if (this.mResponse == null && this.hasDataBlock(0)) {
            this.mResponse = Response.fromValue(this.getDataBlock(0).getMessage().getInt(BLOCK_0_RESPONSE));
        }
        return this.mResponse;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null && this.hasDataBlock(0)) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getDataBlock(0).getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public Identifier getFullyQualifiedTargetAddress() {
        if (this.mFullyQualifiedTargetAddress == null && this.hasDataBlock(0)) {
            int wacn = this.getHeader().getMessage().getInt(HEADER_WACN);
            wacn <<= 4;
            int system = this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM);
            int id = this.getDataBlock(0).getMessage().getInt(BLOCK_0_SOURCE_ID);
            this.mFullyQualifiedTargetAddress = APCO25FullyQualifiedRadioIdentifier.createTo(wacn += this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN), system, id);
        }
        return this.mFullyQualifiedTargetAddress;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null && this.hasDataBlock(0)) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SOURCE_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getFullyQualifiedTargetAddress() != null) {
                this.mIdentifiers.add(this.getFullyQualifiedTargetAddress());
            }
            if (this.getTargetAddress() != null) {
                this.mIdentifiers.add(this.getTargetAddress());
            }
            if (this.getSourceAddress() != null) {
                this.mIdentifiers.add(this.getSourceAddress());
            }
        }
        return this.mIdentifiers;
    }
}

