/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import java.util.ArrayList;
import java.util.List;

public class AMBTCRoamingAddressUpdate
extends AMBTCMessage {
    private static final int LAST_MESSAGE_FLAG = 64;
    private static final int[] HEADER_MSN = new int[]{68, 69, 70, 71};
    private static final int[] HEADER_WACN_A = new int[]{72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_WACN_A = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] BLOCK_0_SYSTEM_A = new int[]{12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
    private Identifier mWacn;
    private Identifier mSystem;
    private Identifier mTargetAddress;
    private List<Identifier> mIdentifiers;

    public AMBTCRoamingAddressUpdate(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        if (this.getTargetAddress() != null) {
            sb.append(" TO:").append(this.getTargetAddress());
        }
        if (this.getWacn() != null) {
            sb.append(" WACN A:").append(this.getWacn());
        }
        if (this.getSystem() != null) {
            sb.append(" SYSTEM A:").append(this.getSystem());
        }
        sb.append(" MSN:").append(this.getMessageSequenceNumber());
        if (this.isLastMessage()) {
            sb.append(" (FINAL)");
        }
        sb.append(" TOTAL WACN/SYSTEM COMBOS IN MESSAGE:").append(this.getWacnCount());
        return sb.toString();
    }

    private int getWacnCount() {
        int dataBlockCount = this.getPDUSequence().getDataBlocks().size();
        switch (dataBlockCount) {
            case 1: {
                return 2;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 2;
    }

    public boolean isLastMessage() {
        return this.getHeader().getMessage().get(64);
    }

    private int getMessageSequenceNumber() {
        return this.getHeader().getMessage().getInt(HEADER_MSN);
    }

    public Identifier getWacn() {
        if (this.mWacn == null && this.hasDataBlock(0)) {
            int value = this.getHeader().getMessage().getInt(HEADER_WACN_A);
            value <<= 12;
            this.mWacn = APCO25Wacn.create(value += this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN_A));
        }
        return this.mWacn;
    }

    public Identifier getSystem() {
        if (this.mSystem == null && this.hasDataBlock(0)) {
            this.mSystem = APCO25System.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM_A));
        }
        return this.mSystem;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null && this.hasDataBlock(0)) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getDataBlock(0).getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mTargetAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getWacn() != null) {
                this.mIdentifiers.add(this.getWacn());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
            if (this.getTargetAddress() != null) {
                this.mIdentifiers.add(this.getTargetAddress());
            }
        }
        return this.mIdentifiers;
    }
}

