/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.isp;

import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25System;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Wacn;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import java.util.ArrayList;
import java.util.List;

public class AMBTCAuthenticationResponse
extends AMBTCMessage {
    private static final int[] HEADER_WACN = new int[]{64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79};
    private static final int[] BLOCK_0_WACN = new int[]{0, 1, 2, 3};
    private static final int[] BLOCK_0_SYSTEM = new int[]{4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] BLOCK_0_SOURCE_ID = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] BLOCK_0_AUTHENTICATION_VALUE = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] BLOCK_1_AUTHENTICATION_VALUE = new int[]{0, 1, 2, 3};
    private String mAuthenticationValue;
    private Identifier mWacn;
    private Identifier mSystem;
    private Identifier mTargetAddress;
    private Identifier mSourceId;
    private List<Identifier> mIdentifiers;

    public AMBTCAuthenticationResponse(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(PDUSequence2, nac, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" FM:").append(this.getSourceId());
        if (this.getSourceId() != null) {
            sb.append(" TO:").append(this.getTargetAddress());
        }
        if (this.getWacn() != null) {
            sb.append(" WACN:").append(this.getWacn());
        }
        if (this.getSystem() != null) {
            sb.append(" SYSTEM:").append(this.getSystem());
        }
        if (this.getAuthenticationValue() != null) {
            sb.append(" AUTHENTICATION:").append(this.getAuthenticationValue());
        }
        return sb.toString();
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getHeader().getMessage().getInt(HEADER_ADDRESS));
        }
        return this.mTargetAddress;
    }

    public Identifier getWacn() {
        if (this.mWacn == null && this.hasDataBlock(0)) {
            int value = this.getHeader().getMessage().getInt(HEADER_WACN);
            value <<= 4;
            this.mWacn = APCO25Wacn.create(value += this.getDataBlock(0).getMessage().getInt(BLOCK_0_WACN));
        }
        return this.mWacn;
    }

    public Identifier getSystem() {
        if (this.mSystem == null && this.hasDataBlock(0)) {
            this.mSystem = APCO25System.create(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SYSTEM));
        }
        return this.mSystem;
    }

    public Identifier getSourceId() {
        if (this.mSourceId == null && this.hasDataBlock(0)) {
            this.mSourceId = APCO25RadioIdentifier.createFrom(this.getDataBlock(0).getMessage().getInt(BLOCK_0_SOURCE_ID));
        }
        return this.mSourceId;
    }

    public String getAuthenticationValue() {
        if (this.mAuthenticationValue == null && this.hasDataBlock(0) && this.hasDataBlock(1)) {
            this.mAuthenticationValue = this.getDataBlock(0).getMessage().getHex(BLOCK_0_AUTHENTICATION_VALUE, 14) + this.getDataBlock(1).getMessage().getHex(BLOCK_1_AUTHENTICATION_VALUE, 2);
        }
        return this.mAuthenticationValue;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            if (this.getTargetAddress() != null) {
                this.mIdentifiers.add(this.getTargetAddress());
            }
            if (this.getWacn() != null) {
                this.mIdentifiers.add(this.getWacn());
            }
            if (this.getSystem() != null) {
                this.mIdentifiers.add(this.getSystem());
            }
            if (this.getSourceId() != null) {
                this.mIdentifiers.add(this.getSourceId());
            }
        }
        return this.mIdentifiers;
    }
}

