/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.message.IBitErrorProvider;
import io.github.dsheirer.module.decode.p25.P25Utils;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.PDUSequence;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCHeader;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.DataBlock;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.block.UnconfirmedDataBlock;
import java.util.List;

public abstract class AMBTCMessage
extends P25Message
implements IBitErrorProvider {
    protected static final int[] HEADER_ADDRESS = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private PDUSequence mPDUSequence;

    public AMBTCMessage(PDUSequence PDUSequence2, int nac, long timestamp) {
        super(nac, timestamp);
        this.mPDUSequence = PDUSequence2;
    }

    @Override
    protected String getMessageStub() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.getMessageStub());
        sb.append(" ").append((Object)this.getHeader().getOpcode());
        P25Utils.pad(sb, 30);
        return sb.toString();
    }

    public AMBTCHeader getHeader() {
        return (AMBTCHeader)this.getPDUSequence().getHeader();
    }

    public boolean hasDataBlock(int index) {
        return index < this.getPDUSequence().getDataBlocks().size();
    }

    public UnconfirmedDataBlock getDataBlock(int index) {
        DataBlock dataBlock;
        if (index < this.getPDUSequence().getDataBlocks().size() && (dataBlock = this.getPDUSequence().getDataBlocks().get(index)) instanceof UnconfirmedDataBlock) {
            return (UnconfirmedDataBlock)dataBlock;
        }
        return null;
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return P25P1DataUnitID.ALTERNATE_MULTI_BLOCK_TRUNKING_CONTROL;
    }

    @Override
    public abstract List<Identifier> getIdentifiers();

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NAC:").append(this.getNAC());
        if (!this.getPDUSequence().isComplete()) {
            sb.append(" *INCOMPLETE - RECEIVED ").append(this.getPDUSequence().getDataBlocks().size()).append("/").append(this.getPDUSequence().getHeader().getBlocksToFollowCount()).append(" DATA BLOCKS");
        }
        sb.append(" ").append(this.getPDUSequence().getHeader().toString());
        sb.append(" DATA BLOCKS:").append(this.getPDUSequence().getDataBlocks().size());
        if (!this.getPDUSequence().getDataBlocks().isEmpty()) {
            sb.append(" MSG:");
            for (DataBlock dataBlock : this.getPDUSequence().getDataBlocks()) {
                sb.append(dataBlock.getMessage().toHexString());
            }
        }
        sb.append(" COMPLETE:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public PDUSequence getPDUSequence() {
        return this.mPDUSequence;
    }

    private void extractMessage() {
        int length = 16;
        int blockCount = this.getPDUSequence().getHeader().getBlocksToFollowCount();
        CorrectedBinaryMessage consolidatedMessage = new CorrectedBinaryMessage(length += blockCount * 96);
        AMBTCHeader header = (AMBTCHeader)this.getPDUSequence().getHeader();
        int dataOctetsValue = header.getDataOctets();
        consolidatedMessage.load(0, 16, dataOctetsValue);
        if (this.getPDUSequence().isComplete()) {
            int offset = 16;
            for (DataBlock dataBlock : this.getPDUSequence().getDataBlocks()) {
                if (!(dataBlock instanceof UnconfirmedDataBlock)) continue;
                BinaryMessage dataBlockMessage = dataBlock.getMessage();
                for (int x = 0; x < dataBlockMessage.size(); ++x) {
                    if (!dataBlockMessage.get(x)) continue;
                    consolidatedMessage.set(x + offset);
                }
                offset += dataBlockMessage.size();
            }
        } else {
            this.setValid(false);
        }
        this.setMessage(consolidatedMessage);
    }

    @Override
    public int getBitsProcessedCount() {
        return this.getPDUSequence().getBitsProcessedCount();
    }

    @Override
    public int getBitErrorsCount() {
        return this.getPDUSequence().getBitErrorsCount();
    }
}

