/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.pdu;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import io.github.dsheirer.module.decode.p25.reference.Direction;
import io.github.dsheirer.module.decode.p25.reference.PDUFormat;
import io.github.dsheirer.module.decode.p25.reference.ServiceAccessPoint;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.Collections;
import java.util.List;

public class PDUMessage
extends P25Message {
    public static final int CONFIRMATION_REQUIRED_INDICATOR = 65;
    public static final int PACKET_DIRECTION_INDICATOR = 66;
    public static final int[] FORMAT = new int[]{67, 68, 69, 70, 71};
    public static final int[] SAP_ID = new int[]{74, 75, 76, 77, 78, 79};
    public static final int[] VENDOR_ID = new int[]{80, 81, 82, 83, 84, 85, 86, 87};
    public static final int[] LOGICAL_LINK_ID = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111};
    public static final int[] BLOCKS_TO_FOLLOW = new int[]{113, 114, 115, 116, 117, 118, 119};
    public static final int[] PAD_OCTET_COUNT = new int[]{123, 124, 125, 126, 127};
    public static final int[] OPCODE = new int[]{122, 123, 124, 125, 126, 127};
    public static final int[] DATA_HEADER_OFFSET = new int[]{138, 139, 140, 141, 142, 143};
    public static final int[] PDU_CRC = new int[]{144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159};
    private Identifier mLLID;

    public PDUMessage(CorrectedBinaryMessage message, int nac, long timestamp) {
        super(message, nac, timestamp);
    }

    @Override
    public P25P1DataUnitID getDUID() {
        return P25P1DataUnitID.PACKET_DATA_UNIT;
    }

    @Override
    protected String getMessageStub() {
        StringBuilder sb = new StringBuilder();
        Vendor vendor = this.getVendor();
        sb.append("NAC:");
        sb.append(this.getNAC());
        sb.append(" ");
        switch (this.getFormat()) {
            case ALTERNATE_MULTI_BLOCK_TRUNKING_CONTROL: {
                sb.append("ATSBK");
                break;
            }
            case UNCONFIRMED_MULTI_BLOCK_TRUNKING_CONTROL: {
                sb.append("**** UNCONFIRMED MULTI-BLOCK TRUNKING CONTROL");
                break;
            }
            default: {
                sb.append(this.getDUID().getLabel());
            }
        }
        if (vendor == Vendor.STANDARD) {
            sb.append(" ");
            sb.append(this.getOpcode().getLabel());
        } else {
            sb.append(" ");
            sb.append(vendor.getLabel());
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        switch (this.getFormat()) {
            case ALTERNATE_MULTI_BLOCK_TRUNKING_CONTROL: {
                break;
            }
            case UNCONFIRMED_MULTI_BLOCK_TRUNKING_CONTROL: {
                sb.append(" PAD OCTETS:").append(this.getPadOctetCount());
                sb.append(" DATA HDR OFFSET:").append(this.getDataHeaderOffset());
                break;
            }
        }
        sb.append(" ");
        sb.append(this.getConfirmation());
        sb.append(" ");
        sb.append(this.getDirection());
        sb.append(" FMT:");
        sb.append(this.getFormat().getLabel());
        sb.append(" SAP:");
        sb.append(this.getServiceAccessPoint().name());
        sb.append(" VEND:");
        sb.append(this.getVendor().getLabel());
        sb.append(" LLID:");
        sb.append(this.getLogicalLinkID());
        sb.append(" BLKS TO FOLLOW:");
        sb.append(this.getBlocksToFollowCount());
        return sb.toString();
    }

    public String getConfirmation() {
        return this.getMessage().get(65) ? "CONFIRMED" : "UNCONFIRMED";
    }

    public String getDirection() {
        return this.getMessage().get(66) ? "OSP" : "ISP";
    }

    public boolean isOutbound() {
        return this.getMessage().get(66);
    }

    public PDUFormat getFormat() {
        return PDUFormat.fromValue(this.getMessage().getInt(FORMAT));
    }

    public ServiceAccessPoint getServiceAccessPoint() {
        return ServiceAccessPoint.fromValue(this.getMessage().getInt(SAP_ID));
    }

    public Vendor getVendor() {
        return Vendor.fromValue(this.getMessage().getInt(VENDOR_ID));
    }

    public Identifier getLogicalLinkID() {
        if (this.mLLID == null) {
            this.mLLID = this.isOutbound() ? APCO25RadioIdentifier.createTo(this.getMessage().getInt(LOGICAL_LINK_ID)) : APCO25RadioIdentifier.createFrom(this.getMessage().getInt(LOGICAL_LINK_ID));
        }
        return this.mLLID;
    }

    public int getBlocksToFollowCount() {
        return this.getMessage().getInt(BLOCKS_TO_FOLLOW);
    }

    public int getPadOctetCount() {
        return this.getMessage().getInt(PAD_OCTET_COUNT);
    }

    public Opcode getOpcode() {
        if (this.getFormat() == PDUFormat.ALTERNATE_MULTI_BLOCK_TRUNKING_CONTROL) {
            return Opcode.fromValue(this.getMessage().getInt(OPCODE), Direction.OUTBOUND, this.getVendor());
        }
        return Opcode.OSP_UNKNOWN;
    }

    public int getDataHeaderOffset() {
        return this.getMessage().getInt(DATA_HEADER_OFFSET);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

