/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.standard;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.Service;
import java.util.Collections;
import java.util.List;

public class LCSystemServiceBroadcast
extends LinkControlWord {
    private static final int[] REQUEST_PRIORITY_LEVEL = new int[]{20, 21, 22, 23};
    private static final int[] AVAILABLE_SERVICES = new int[]{24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SUPPORTED_SERVICES = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};

    public LCSystemServiceBroadcast(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getMessageStub());
        sb.append(" REQUEST PRIORITY LEVEL:").append(this.getRequestPriorityLevel());
        sb.append(" AVAILABLE SERVICES ").append(this.getAvailableServices());
        sb.append(" SUPPORTED SERVICES ").append(this.getSupportedServices());
        return sb.toString();
    }

    public int getRequestPriorityLevel() {
        return this.getMessage().getInt(REQUEST_PRIORITY_LEVEL);
    }

    public List<Service> getAvailableServices() {
        long bitmap = this.getMessage().getLong(AVAILABLE_SERVICES);
        return Service.getServices(bitmap);
    }

    public List<Service> getSupportedServices() {
        long bitmap = this.getMessage().getLong(SUPPORTED_SERVICES);
        return Service.getServices(bitmap);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

