/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola.MotorolaLinkControlWord;
import java.util.Collections;
import java.util.List;

public class LCMotorolaUnitGPS
extends MotorolaLinkControlWord {
    private static final double LATITUDE_MULTIPLIER = 1.072883733854739E-5;
    private static final double LONGITUDE_MULTIPLIER = 2.145767467709478E-5;
    private static final int[] UNKNOWN = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int LATITUDE_SIGN = 24;
    private static final int[] LATITUDE = new int[]{25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int LONGITUDE_SIGN = 48;
    private static final int[] LONGITUDE = new int[]{49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};

    public LCMotorolaUnitGPS(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MOTOROLA UNIT GPS LOCATION: ").append(this.getLatitude()).append(" ").append(this.getLongitude());
        return sb.toString();
    }

    public double getLatitude() {
        return (double)this.getMessage().getInt(LATITUDE) * 1.072883733854739E-5 * (double)(this.getMessage().get(24) ? -1 : 1);
    }

    public double getLongitude() {
        return (double)this.getMessage().getInt(LONGITUDE) * 2.145767467709478E-5 * (double)(this.getMessage().get(48) ? -1 : 1);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.emptyList();
    }
}

