/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import java.util.ArrayList;
import java.util.List;

public class LCMotorolaTalkComplete
extends LinkControlWord {
    private static final int[] UNKNOWN_FIELD_1 = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] UNKNOWN_FIELD_2 = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private Identifier mAddress;
    private List<Identifier> mIdentifiers;

    public LCMotorolaTalkComplete(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("**CRC-FAILED** ");
        }
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        } else {
            sb.append("MOTOROLA TALK COMPLETE");
            sb.append(" BY:").append(this.getAddress());
            sb.append(" UNK1:").append(this.getUnknownField1());
            sb.append(" UNK2:").append(this.getUnknownField2());
            sb.append(" MSG:").append(this.getMessage().toHexString());
        }
        return sb.toString();
    }

    public String getUnknownField1() {
        return this.getMessage().getHex(UNKNOWN_FIELD_1, 2);
    }

    public String getUnknownField2() {
        return this.getMessage().getHex(UNKNOWN_FIELD_2, 2);
    }

    public Identifier getAddress() {
        if (this.mAddress == null) {
            this.mAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(ADDRESS));
        }
        return this.mAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getAddress());
        }
        return this.mIdentifiers;
    }
}

