/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola.MotorolaLinkControlWord;
import io.github.dsheirer.module.decode.p25.reference.VoiceServiceOptions;
import java.util.ArrayList;
import java.util.List;

public class LCMotorolaPatchGroupVoiceChannelUser
extends MotorolaLinkControlWord {
    private static final int[] SERVICE_OPTIONS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] PATCH_GROUP_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] SOURCE_ADDRESS = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71};
    private VoiceServiceOptions mVoiceServiceOptions;
    private APCO25PatchGroup mGroupAddress;
    private Identifier mSourceAddress;
    private List<Identifier> mIdentifiers;

    public LCMotorolaPatchGroupVoiceChannelUser(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MOTOROLA PATCH GROUP VOICE CHANNEL USER FM:").append(this.getSourceAddress());
        sb.append(" TO:").append(this.getGroupAddress());
        sb.append(" ").append(this.getVoiceServiceOptions());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public VoiceServiceOptions getVoiceServiceOptions() {
        if (this.mVoiceServiceOptions == null) {
            this.mVoiceServiceOptions = new VoiceServiceOptions(this.getMessage().getInt(SERVICE_OPTIONS));
        }
        return this.mVoiceServiceOptions;
    }

    public APCO25PatchGroup getGroupAddress() {
        if (this.mGroupAddress == null) {
            PatchGroup patchGroup = new PatchGroup(APCO25Talkgroup.create(this.getMessage().getInt(PATCH_GROUP_ADDRESS)));
            this.mGroupAddress = APCO25PatchGroup.create(patchGroup);
        }
        return this.mGroupAddress;
    }

    public Identifier getSourceAddress() {
        if (this.mSourceAddress == null) {
            this.mSourceAddress = APCO25RadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_ADDRESS));
        }
        return this.mSourceAddress;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getGroupAddress());
            this.mIdentifiers.add(this.getSourceAddress());
        }
        return this.mIdentifiers;
    }
}

