/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.patch.PatchGroup;
import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.patch.APCO25PatchGroup;
import io.github.dsheirer.module.decode.p25.identifier.talkgroup.APCO25Talkgroup;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola.MotorolaLinkControlWord;
import java.util.ArrayList;
import java.util.List;

public class LCMotorolaPatchGroupAdd
extends MotorolaLinkControlWord {
    private static final int[] PATCH_GROUP = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] PATCHED_GROUP_1 = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] PATCHED_GROUP_2 = new int[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private APCO25PatchGroup mPatchGroup;
    private TalkgroupIdentifier mPatchedGroup1;
    private TalkgroupIdentifier mPatchedGroup2;
    private List<Identifier> mIdentifiers;

    public LCMotorolaPatchGroupAdd(BinaryMessage message) {
        super(message);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MOTOROLA ADD PATCH GROUP:").append(this.getPatchGroup());
        sb.append(" MSG:").append(this.getMessage().toHexString());
        return sb.toString();
    }

    public Identifier getPatchGroup() {
        if (this.mPatchGroup == null) {
            PatchGroup patchGroup = new PatchGroup(APCO25Talkgroup.create(this.getMessage().getInt(PATCH_GROUP)));
            patchGroup.addPatchedTalkgroups(this.getPatchedGroups());
            this.mPatchGroup = APCO25PatchGroup.create(patchGroup);
        }
        return this.mPatchGroup;
    }

    public List<TalkgroupIdentifier> getPatchedGroups() {
        ArrayList<TalkgroupIdentifier> patchedGroups = new ArrayList<TalkgroupIdentifier>();
        if (this.hasPatchedGroup1()) {
            patchedGroups.add(this.getPatchedGroup1());
        }
        if (this.hasPatchedGroup2()) {
            patchedGroups.add(this.getPatchedGroup2());
        }
        return patchedGroups;
    }

    public TalkgroupIdentifier getPatchedGroup1() {
        if (this.mPatchedGroup1 == null) {
            this.mPatchedGroup1 = APCO25Talkgroup.create(this.getMessage().getInt(PATCHED_GROUP_1));
        }
        return this.mPatchedGroup1;
    }

    public boolean hasPatchedGroup1() {
        return this.getMessage().getInt(PATCHED_GROUP_1) != 0 && this.getMessage().getInt(PATCH_GROUP) != this.getMessage().getInt(PATCHED_GROUP_1);
    }

    public TalkgroupIdentifier getPatchedGroup2() {
        if (this.mPatchedGroup2 == null) {
            this.mPatchedGroup2 = APCO25Talkgroup.create(this.getMessage().getInt(PATCHED_GROUP_2));
        }
        return this.mPatchedGroup2;
    }

    public boolean hasPatchedGroup2() {
        return this.getMessage().getInt(PATCHED_GROUP_2) != 0 && this.getMessage().getInt(PATCH_GROUP) != this.getMessage().getInt(PATCHED_GROUP_2);
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getPatchGroup());
        }
        return this.mIdentifiers;
    }
}

