/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.lc;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlOpcode;
import io.github.dsheirer.module.decode.p25.reference.Vendor;
import java.util.List;

public abstract class LinkControlWord {
    private static final int ENCRYPTION_FLAG = 0;
    private static final int STANDARD_VENDOR_ID_FLAG = 1;
    private static final int[] OPCODE = new int[]{2, 3, 4, 5, 6, 7};
    private static final int[] VENDOR = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private BinaryMessage mMessage;
    private LinkControlOpcode mLinkControlOpcode;
    private boolean mValid = true;

    public LinkControlWord(BinaryMessage message) {
        this.mMessage = message;
    }

    protected BinaryMessage getMessage() {
        return this.mMessage;
    }

    public void setValid(boolean valid) {
        this.mValid = valid;
    }

    public boolean isValid() {
        return this.mValid;
    }

    public boolean isEncrypted() {
        return this.getMessage().get(0);
    }

    public boolean isStandardVendorFormat() {
        return LinkControlWord.isStandardVendorFormat(this.getMessage());
    }

    public static boolean isStandardVendorFormat(BinaryMessage binaryMessage) {
        return binaryMessage.get(1);
    }

    public Vendor getVendor() {
        return LinkControlWord.getVendor(this.getMessage());
    }

    public static Vendor getVendor(BinaryMessage binaryMessage) {
        if (LinkControlWord.isStandardVendorFormat(binaryMessage)) {
            return Vendor.STANDARD;
        }
        return Vendor.fromValue(binaryMessage.getInt(VENDOR));
    }

    public LinkControlOpcode getOpcode() {
        if (this.mLinkControlOpcode == null) {
            this.mLinkControlOpcode = LinkControlWord.getOpcode(this.getMessage());
        }
        return this.mLinkControlOpcode;
    }

    public int getOpcodeNumber() {
        return this.getMessage().getInt(OPCODE);
    }

    public static LinkControlOpcode getOpcode(BinaryMessage binaryMessage) {
        return LinkControlOpcode.fromValue(binaryMessage.getInt(OPCODE), LinkControlWord.getVendor(binaryMessage));
    }

    public abstract List<Identifier> getIdentifiers();

    public String getMessageStub() {
        Vendor vendor;
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("***LINK CONTROL CRC FAIL*** ");
        }
        sb.append(this.getOpcode().getLabel());
        if (this.isEncrypted()) {
            sb.append(" ENCRYPTED");
        } else if (!this.isStandardVendorFormat() && (vendor = this.getVendor()) != Vendor.STANDARD) {
            sb.append(" ").append(vendor.getLabel());
        }
        return sb.toString();
    }
}

