/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1.message.filter;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlOpcode;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDULinkControlMessage;
import java.util.Collection;
import java.util.function.Function;

public class TerminatorMessageFilter
extends Filter<IMessage, LinkControlOpcode> {
    private KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public TerminatorMessageFilter(String name, Collection<LinkControlOpcode> opcodes) {
        super(name);
        for (LinkControlOpcode opcode : opcodes) {
            this.add(new FilterElement<LinkControlOpcode>(opcode));
        }
    }

    @Override
    public Function<IMessage, LinkControlOpcode> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, LinkControlOpcode> {
        private KeyExtractor(TerminatorMessageFilter terminatorMessageFilter) {
        }

        @Override
        public LinkControlOpcode apply(IMessage message) {
            if (message instanceof TDULinkControlMessage) {
                TDULinkControlMessage tdulc = (TDULinkControlMessage)message;
                return tdulc.getLinkControlWord().getOpcode();
            }
            return null;
        }
    }
}

