/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1;

import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase1.P25P1Decoder;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCAdjacentSiteStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCAdjacentSiteStatusBroadcastExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCNetworkStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCNetworkStatusBroadcastExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCRFSSStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCRFSSStatusBroadcastExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCSecondaryControlChannelBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCSecondaryControlChannelBroadcastExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCSystemServiceBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.AMBTCMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCAdjacentStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCNetworkStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCRFSSStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.TSBKMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.motorola.osp.MotorolaBaseStationId;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.AdjacentStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.NetworkStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.RFSSStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.SNDCPDataChannelAnnouncementExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.SecondaryControlChannelBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.SecondaryControlChannelBroadcastExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.SystemServiceBroadcast;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1NetworkConfigurationMonitor {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1NetworkConfigurationMonitor.class);
    private Map<Integer, IFrequencyBand> mFrequencyBandMap = new HashMap<Integer, IFrequencyBand>();
    private AMBTCNetworkStatusBroadcast mAMBTCNetworkStatusBroadcast;
    private NetworkStatusBroadcast mTSBKNetworkStatusBroadcast;
    private LCNetworkStatusBroadcast mLCNetworkStatusBroadcast;
    private LCNetworkStatusBroadcastExplicit mLCNetworkStatusBroadcastExplicit;
    private RFSSStatusBroadcast mTSBKRFSSStatusBroadcast;
    private AMBTCRFSSStatusBroadcast mAMBTCRFSSStatusBroadcast;
    private LCRFSSStatusBroadcast mLCRFSSStatusBroadcast;
    private LCRFSSStatusBroadcastExplicit mLCRFSSStatusBroadcastExplicit;
    private Map<String, IChannelDescriptor> mSecondaryControlChannels = new TreeMap<String, IChannelDescriptor>();
    private SNDCPDataChannelAnnouncementExplicit mSNDCPDataChannel;
    private SystemServiceBroadcast mTSBKSystemServiceBroadcast;
    private LCSystemServiceBroadcast mLCSystemServiceBroadcast;
    private Map<Integer, AMBTCAdjacentStatusBroadcast> mAMBTCNeighborSites = new HashMap<Integer, AMBTCAdjacentStatusBroadcast>();
    private Map<Integer, LCAdjacentSiteStatusBroadcast> mLCNeighborSites = new HashMap<Integer, LCAdjacentSiteStatusBroadcast>();
    private Map<Integer, LCAdjacentSiteStatusBroadcastExplicit> mLCNeighborSitesExplicit = new HashMap<Integer, LCAdjacentSiteStatusBroadcastExplicit>();
    private Map<Integer, AdjacentStatusBroadcast> mTSBKNeighborSites = new HashMap<Integer, AdjacentStatusBroadcast>();
    private MotorolaBaseStationId mMotorolaBaseStationId;
    private P25P1Decoder.Modulation mModulation;

    public P25P1NetworkConfigurationMonitor(P25P1Decoder.Modulation modulation) {
        this.mModulation = modulation;
    }

    public void process(TSBKMessage tsbk) {
        switch (tsbk.getOpcode()) {
            case OSP_IDENTIFIER_UPDATE: 
            case OSP_IDENTIFIER_UPDATE_TDMA: 
            case OSP_IDENTIFIER_UPDATE_VHF_UHF_BANDS: {
                if (!(tsbk instanceof IFrequencyBand)) break;
                IFrequencyBand frequencyBand = (IFrequencyBand)((Object)tsbk);
                this.mFrequencyBandMap.put(frequencyBand.getIdentifier(), frequencyBand);
                break;
            }
            case OSP_NETWORK_STATUS_BROADCAST: {
                if (!(tsbk instanceof NetworkStatusBroadcast)) break;
                this.mTSBKNetworkStatusBroadcast = (NetworkStatusBroadcast)tsbk;
                break;
            }
            case OSP_SYSTEM_SERVICE_BROADCAST: {
                if (!(tsbk instanceof SystemServiceBroadcast)) break;
                this.mTSBKSystemServiceBroadcast = (SystemServiceBroadcast)tsbk;
                break;
            }
            case OSP_RFSS_STATUS_BROADCAST: {
                if (!(tsbk instanceof RFSSStatusBroadcast)) break;
                this.mTSBKRFSSStatusBroadcast = (RFSSStatusBroadcast)tsbk;
                break;
            }
            case OSP_SECONDARY_CONTROL_CHANNEL_BROADCAST: {
                if (!(tsbk instanceof SecondaryControlChannelBroadcast)) break;
                SecondaryControlChannelBroadcast sccb = (SecondaryControlChannelBroadcast)tsbk;
                for (IChannelDescriptor secondaryControlChannel : sccb.getChannels()) {
                    this.mSecondaryControlChannels.put(secondaryControlChannel.toString(), secondaryControlChannel);
                }
                break;
            }
            case OSP_SECONDARY_CONTROL_CHANNEL_BROADCAST_EXPLICIT: {
                if (!(tsbk instanceof SecondaryControlChannelBroadcastExplicit)) break;
                SecondaryControlChannelBroadcastExplicit sccbe = (SecondaryControlChannelBroadcastExplicit)tsbk;
                IChannelDescriptor channel = sccbe.getChannel();
                this.mSecondaryControlChannels.put(channel.toString(), channel);
                break;
            }
            case OSP_ADJACENT_STATUS_BROADCAST: {
                if (!(tsbk instanceof AdjacentStatusBroadcast)) break;
                AdjacentStatusBroadcast asb = (AdjacentStatusBroadcast)tsbk;
                this.mTSBKNeighborSites.put((int)((Integer)asb.getSite().getValue()), asb);
                break;
            }
            case OSP_SNDCP_DATA_CHANNEL_ANNOUNCEMENT_EXPLICIT: {
                if (!(tsbk instanceof SNDCPDataChannelAnnouncementExplicit)) break;
                this.mSNDCPDataChannel = (SNDCPDataChannelAnnouncementExplicit)tsbk;
                break;
            }
            case MOTOROLA_OSP_BASE_STATION_ID: {
                if (!(tsbk instanceof MotorolaBaseStationId)) break;
                this.mMotorolaBaseStationId = (MotorolaBaseStationId)tsbk;
            }
        }
    }

    public void process(AMBTCMessage ambtc) {
        switch (ambtc.getHeader().getOpcode()) {
            case OSP_ADJACENT_STATUS_BROADCAST: {
                if (!(ambtc instanceof AMBTCAdjacentStatusBroadcast)) break;
                AMBTCAdjacentStatusBroadcast aasb = (AMBTCAdjacentStatusBroadcast)ambtc;
                this.mAMBTCNeighborSites.put((int)((Integer)aasb.getSite().getValue()), aasb);
                break;
            }
            case OSP_NETWORK_STATUS_BROADCAST: {
                if (!(ambtc instanceof AMBTCNetworkStatusBroadcast)) break;
                this.mAMBTCNetworkStatusBroadcast = (AMBTCNetworkStatusBroadcast)ambtc;
                break;
            }
            case OSP_RFSS_STATUS_BROADCAST: {
                if (!(ambtc instanceof AMBTCRFSSStatusBroadcast)) break;
                this.mAMBTCRFSSStatusBroadcast = (AMBTCRFSSStatusBroadcast)ambtc;
            }
        }
    }

    public void process(LinkControlWord lcw) {
        if (lcw.isValid()) {
            switch (lcw.getOpcode()) {
                case ADJACENT_SITE_STATUS_BROADCAST: {
                    if (!(lcw instanceof LCAdjacentSiteStatusBroadcast)) break;
                    LCAdjacentSiteStatusBroadcast assb = (LCAdjacentSiteStatusBroadcast)lcw;
                    this.mLCNeighborSites.put((int)((Integer)assb.getSite().getValue()), assb);
                    break;
                }
                case ADJACENT_SITE_STATUS_BROADCAST_EXPLICIT: {
                    if (!(lcw instanceof LCAdjacentSiteStatusBroadcastExplicit)) break;
                    LCAdjacentSiteStatusBroadcastExplicit assbe = (LCAdjacentSiteStatusBroadcastExplicit)lcw;
                    this.mLCNeighborSitesExplicit.put((int)((Integer)assbe.getSite().getValue()), assbe);
                    break;
                }
                case CHANNEL_IDENTIFIER_UPDATE: 
                case CHANNEL_IDENTIFIER_UPDATE_EXPLICIT: {
                    if (!(lcw instanceof IFrequencyBand)) break;
                    IFrequencyBand band = (IFrequencyBand)((Object)lcw);
                    this.mFrequencyBandMap.put(band.getIdentifier(), band);
                    break;
                }
                case NETWORK_STATUS_BROADCAST: {
                    if (!(lcw instanceof LCNetworkStatusBroadcast)) break;
                    this.mLCNetworkStatusBroadcast = (LCNetworkStatusBroadcast)lcw;
                    break;
                }
                case NETWORK_STATUS_BROADCAST_EXPLICIT: {
                    if (!(lcw instanceof LCNetworkStatusBroadcastExplicit)) break;
                    this.mLCNetworkStatusBroadcastExplicit = (LCNetworkStatusBroadcastExplicit)lcw;
                    break;
                }
                case RFSS_STATUS_BROADCAST: {
                    if (!(lcw instanceof LCRFSSStatusBroadcast)) break;
                    this.mLCRFSSStatusBroadcast = (LCRFSSStatusBroadcast)lcw;
                    break;
                }
                case RFSS_STATUS_BROADCAST_EXPLICIT: {
                    if (!(lcw instanceof LCRFSSStatusBroadcastExplicit)) break;
                    this.mLCRFSSStatusBroadcastExplicit = (LCRFSSStatusBroadcastExplicit)lcw;
                    break;
                }
                case SECONDARY_CONTROL_CHANNEL_BROADCAST: {
                    if (!(lcw instanceof LCSecondaryControlChannelBroadcast)) break;
                    LCSecondaryControlChannelBroadcast sccb = (LCSecondaryControlChannelBroadcast)lcw;
                    for (IChannelDescriptor channel : sccb.getChannels()) {
                        this.mSecondaryControlChannels.put(channel.toString(), channel);
                    }
                    break;
                }
                case SECONDARY_CONTROL_CHANNEL_BROADCAST_EXPLICIT: {
                    if (!(lcw instanceof LCSecondaryControlChannelBroadcastExplicit)) break;
                    LCSecondaryControlChannelBroadcastExplicit sccb = (LCSecondaryControlChannelBroadcastExplicit)lcw;
                    for (IChannelDescriptor channel : sccb.getChannels()) {
                        this.mSecondaryControlChannels.put(channel.toString(), channel);
                    }
                    break;
                }
                case SYSTEM_SERVICE_BROADCAST: {
                    if (!(lcw instanceof LCSystemServiceBroadcast)) break;
                    this.mLCSystemServiceBroadcast = (LCSystemServiceBroadcast)lcw;
                }
            }
        }
    }

    public void reset() {
        this.mFrequencyBandMap.clear();
        this.mAMBTCNetworkStatusBroadcast = null;
        this.mTSBKNetworkStatusBroadcast = null;
        this.mLCNetworkStatusBroadcast = null;
        this.mLCNetworkStatusBroadcastExplicit = null;
        this.mTSBKRFSSStatusBroadcast = null;
        this.mLCRFSSStatusBroadcast = null;
        this.mLCRFSSStatusBroadcastExplicit = null;
        this.mSecondaryControlChannels.clear();
        this.mSNDCPDataChannel = null;
        this.mTSBKSystemServiceBroadcast = null;
        this.mLCSystemServiceBroadcast = null;
        this.mAMBTCNeighborSites = new HashMap<Integer, AMBTCAdjacentStatusBroadcast>();
        this.mLCNeighborSites.clear();
        this.mLCNeighborSitesExplicit.clear();
        this.mTSBKNeighborSites.clear();
    }

    private String format(Identifier identifier, int width) {
        if (identifier.getValue() instanceof Integer) {
            String hex = StringUtils.leftPad((String)Integer.toHexString((Integer)identifier.getValue()), (int)width, (char)'0');
            return hex.toUpperCase() + "[" + String.valueOf(identifier.getValue()) + "]";
        }
        return identifier.toString();
    }

    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary - Decoder:P25 Phase 1 ").append(this.mModulation.getLabel());
        sb.append("\n\nNetwork\n");
        if (this.mTSBKNetworkStatusBroadcast != null) {
            sb.append("  WACN:").append(this.format(this.mTSBKNetworkStatusBroadcast.getWacn(), 5));
            sb.append(" SYSTEM:").append(this.format(this.mTSBKNetworkStatusBroadcast.getSystem(), 3));
            sb.append(" NAC:").append(this.format(this.mTSBKNetworkStatusBroadcast.getNAC(), 3));
            sb.append(" LRA:").append(this.format(this.mTSBKNetworkStatusBroadcast.getLocationRegistrationArea(), 2));
        } else if (this.mAMBTCNetworkStatusBroadcast != null) {
            sb.append("  WACN:").append(this.format(this.mAMBTCNetworkStatusBroadcast.getWacn(), 5));
            sb.append(" SYSTEM:").append(this.format(this.mAMBTCNetworkStatusBroadcast.getSystem(), 3));
            sb.append(" NAC:").append(this.format(this.mAMBTCNetworkStatusBroadcast.getNAC(), 3));
        } else if (this.mLCNetworkStatusBroadcast != null) {
            sb.append("  WACN:").append(this.format(this.mLCNetworkStatusBroadcast.getWACN(), 5));
            sb.append(" SYSTEM:").append(this.format(this.mLCNetworkStatusBroadcast.getSystem(), 3));
        } else if (this.mLCNetworkStatusBroadcastExplicit != null) {
            sb.append("  WACN:").append(this.format(this.mLCNetworkStatusBroadcastExplicit.getWACN(), 5));
            sb.append(" SYSTEM:").append(this.format(this.mLCNetworkStatusBroadcastExplicit.getSystem(), 3));
        } else {
            sb.append("  UNKNOWN");
        }
        sb.append("\n\nCurrent Site\n");
        if (this.mTSBKRFSSStatusBroadcast != null) {
            sb.append("  SYSTEM:").append(this.format(this.mTSBKRFSSStatusBroadcast.getSystem(), 3));
            sb.append(" NAC:").append(this.format(this.mTSBKRFSSStatusBroadcast.getNAC(), 3));
            sb.append(" RFSS:").append(this.format(this.mTSBKRFSSStatusBroadcast.getRfss(), 2));
            sb.append(" SITE:").append(this.format(this.mTSBKRFSSStatusBroadcast.getSite(), 2));
            sb.append(" LRA:").append(this.format(this.mTSBKRFSSStatusBroadcast.getLocationRegistrationArea(), 2));
            sb.append("  STATUS:").append(this.mTSBKRFSSStatusBroadcast.isActiveNetworkConnectionToRfssControllerSite() ? "ACTIVE RFSS NETWORK CONNECTION\n" : "\n");
            sb.append("  PRI CONTROL CHANNEL:").append(this.mTSBKRFSSStatusBroadcast.getChannel());
            sb.append(" DOWNLINK:").append(this.mTSBKRFSSStatusBroadcast.getChannel().getDownlinkFrequency());
            sb.append(" UPLINK:").append(this.mTSBKRFSSStatusBroadcast.getChannel().getUplinkFrequency()).append("\n");
        } else if (this.mLCRFSSStatusBroadcast != null) {
            sb.append("  SYSTEM:").append(this.format(this.mLCRFSSStatusBroadcast.getSystem(), 3));
            sb.append(" RFSS:").append(this.format(this.mLCRFSSStatusBroadcast.getRfss(), 2));
            sb.append(" SITE:").append(this.format(this.mLCRFSSStatusBroadcast.getSite(), 2));
            sb.append(" LRA:").append(this.format(this.mLCRFSSStatusBroadcast.getLocationRegistrationArea(), 2)).append("\n");
            sb.append("  PRI CONTROL CHANNEL:").append(this.mLCRFSSStatusBroadcast.getChannel());
            sb.append(" DOWNLINK:").append(this.mLCRFSSStatusBroadcast.getChannel().getDownlinkFrequency());
            sb.append(" UPLINK:").append(this.mLCRFSSStatusBroadcast.getChannel().getUplinkFrequency()).append("\n");
        } else if (this.mLCRFSSStatusBroadcastExplicit != null) {
            sb.append("  RFSS:").append(this.mLCRFSSStatusBroadcastExplicit.getRfss());
            sb.append(" SITE:").append(this.format(this.mLCRFSSStatusBroadcastExplicit.getSite(), 2));
            sb.append(" LRA:").append(this.format(this.mLCRFSSStatusBroadcastExplicit.getLocationRegistrationArea(), 2)).append("\n");
            sb.append("  PRI CONTROL CHANNEL:").append(this.mLCRFSSStatusBroadcastExplicit.getChannel());
            sb.append(" DOWNLINK:").append(this.mLCRFSSStatusBroadcastExplicit.getChannel().getDownlinkFrequency());
            sb.append(" UPLINK:").append(this.mLCRFSSStatusBroadcastExplicit.getChannel().getUplinkFrequency()).append("\n");
        } else if (this.mAMBTCRFSSStatusBroadcast != null) {
            sb.append("  SYSTEM:").append(this.format(this.mAMBTCRFSSStatusBroadcast.getSystem(), 3));
            sb.append(" NAC:").append(this.format(this.mAMBTCRFSSStatusBroadcast.getNAC(), 3));
            sb.append(" RFSS:").append(this.format(this.mAMBTCRFSSStatusBroadcast.getRFSS(), 2));
            sb.append(" SITE:").append(this.format(this.mAMBTCRFSSStatusBroadcast.getSite(), 2));
            sb.append(" LRA:").append(this.format(this.mAMBTCRFSSStatusBroadcast.getLRA(), 2));
            sb.append("  STATUS:").append(this.mAMBTCRFSSStatusBroadcast.isActiveNetworkConnectionToRfssControllerSite() ? "ACTIVE RFSS NETWORK CONNECTION\n" : "\n");
            sb.append("  PRI CONTROL CHANNEL:").append(this.mAMBTCRFSSStatusBroadcast.getChannel());
            sb.append(" DOWNLINK:").append(this.mAMBTCRFSSStatusBroadcast.getChannel().getDownlinkFrequency());
            sb.append(" UPLINK:").append(this.mAMBTCRFSSStatusBroadcast.getChannel().getUplinkFrequency()).append("\n");
        } else {
            sb.append("  UNKNOWN");
        }
        if (!this.mSecondaryControlChannels.isEmpty()) {
            this.mSecondaryControlChannels.entrySet().stream().sorted(Map.Entry.comparingByKey()).filter(Objects::nonNull).forEach(entry -> {
                sb.append("  SEC CONTROL CHANNEL:").append(entry.getValue());
                sb.append(" DOWNLINK:").append(((IChannelDescriptor)entry.getValue()).getDownlinkFrequency());
                sb.append(" UPLINK:").append(((IChannelDescriptor)entry.getValue()).getUplinkFrequency()).append("\n");
            });
        }
        if (this.mSNDCPDataChannel != null) {
            sb.append("  CURRENT DATA CHANNEL:").append(this.mSNDCPDataChannel.getChannel());
            sb.append(" DOWNLINK:").append(this.mSNDCPDataChannel.getChannel().getDownlinkFrequency());
            sb.append(" UPLINK:").append(this.mSNDCPDataChannel.getChannel().getUplinkFrequency()).append("\n");
        }
        if (this.mMotorolaBaseStationId != null) {
            sb.append("  STATION ID/LICENSE: ").append(this.mMotorolaBaseStationId.getCWID()).append("\n");
        }
        if (this.mTSBKSystemServiceBroadcast != null) {
            sb.append("  AVAILABLE SERVICES:").append(this.mTSBKSystemServiceBroadcast.getAvailableServices());
            sb.append("  SUPPORTED SERVICES:").append(this.mTSBKSystemServiceBroadcast.getSupportedServices());
        } else if (this.mLCSystemServiceBroadcast != null) {
            sb.append("  AVAILABLE SERVICES:").append(this.mLCSystemServiceBroadcast.getAvailableServices());
            sb.append("  SUPPORTED SERVICES:").append(this.mLCSystemServiceBroadcast.getSupportedServices());
        }
        sb.append("\nNeighbor Sites\n");
        TreeSet<Integer> sites = new TreeSet<Integer>();
        sites.addAll(this.mAMBTCNeighborSites.keySet());
        sites.addAll(this.mLCNeighborSites.keySet());
        sites.addAll(this.mLCNeighborSitesExplicit.keySet());
        sites.addAll(this.mTSBKNeighborSites.keySet());
        if (sites.isEmpty()) {
            sb.append("  UNKNOWN");
        } else {
            sites.stream().sorted().forEach(site -> {
                if (this.mAMBTCNeighborSites.containsKey(site)) {
                    AMBTCAdjacentStatusBroadcast ambtc = this.mAMBTCNeighborSites.get(site);
                    sb.append("  SYSTEM:").append(this.format(ambtc.getSystem(), 3));
                    sb.append(" NAC:").append(this.format(ambtc.getNAC(), 3));
                    sb.append(" RFSS:").append(this.format(ambtc.getRfss(), 2));
                    sb.append(" SITE:").append(this.format(ambtc.getSite(), 2));
                    sb.append(" LRA:").append(this.format(ambtc.getLocationRegistrationArea(), 2));
                    sb.append(" CHANNEL:").append(ambtc.getChannel());
                    sb.append(" DOWNLINK:").append(ambtc.getChannel().getDownlinkFrequency());
                    sb.append(" UPLINK:").append(ambtc.getChannel().getUplinkFrequency()).append("\n");
                }
                if (this.mLCNeighborSites.containsKey(site)) {
                    LCAdjacentSiteStatusBroadcast lc = this.mLCNeighborSites.get(site);
                    sb.append("  SYSTEM:").append(this.format(lc.getSystem(), 3));
                    sb.append(" RFSS:").append(this.format(lc.getRfss(), 2));
                    sb.append(" SITE:").append(this.format(lc.getSite(), 2));
                    sb.append(" LRA:").append(this.format(lc.getLocationRegistrationArea(), 2));
                    sb.append(" CHANNEL:").append(lc.getChannel());
                    sb.append(" DOWNLINK:").append(lc.getChannel().getDownlinkFrequency());
                    sb.append(" UPLINK:").append(lc.getChannel().getUplinkFrequency()).append("\n");
                }
                if (this.mLCNeighborSitesExplicit.containsKey(site)) {
                    LCAdjacentSiteStatusBroadcastExplicit lce = this.mLCNeighborSitesExplicit.get(site);
                    sb.append("  SYSTEM:---");
                    sb.append(" RFSS:").append(this.format(lce.getRfss(), 2));
                    sb.append(" SITE:").append(this.format(lce.getSite(), 2));
                    sb.append(" LRA:").append(this.format(lce.getLocationRegistrationArea(), 2));
                    sb.append(" CHANNEL:").append(lce.getChannel());
                    sb.append(" DOWNLINK:").append(lce.getChannel().getDownlinkFrequency());
                    sb.append(" UPLINK:").append(lce.getChannel().getUplinkFrequency()).append("\n");
                }
                if (this.mTSBKNeighborSites.containsKey(site)) {
                    AdjacentStatusBroadcast asb = this.mTSBKNeighborSites.get(site);
                    sb.append("  SYSTEM:").append(this.format(asb.getSystem(), 3));
                    sb.append(" NAC:").append(this.format(asb.getNAC(), 3));
                    sb.append(" RFSS:").append(this.format(asb.getRfss(), 2));
                    sb.append(" SITE:").append(this.format(asb.getSite(), 2));
                    sb.append(" LRA:").append(this.format(asb.getLocationRegistrationArea(), 2));
                    sb.append(" CHANNEL:").append(asb.getChannel());
                    sb.append(" DOWNLINK:").append(asb.getChannel().getDownlinkFrequency());
                    sb.append(" UPLINK:").append(asb.getChannel().getUplinkFrequency());
                    sb.append(" STATUS:").append(asb.getSiteFlags()).append("\n");
                }
            });
        }
        sb.append("\nFrequency Bands\n");
        if (this.mFrequencyBandMap.isEmpty()) {
            sb.append("  UNKNOWN");
        } else {
            this.mFrequencyBandMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sb.append("  ").append(this.formatFrequencyBand((IFrequencyBand)entry.getValue())).append("\n"));
        }
        return sb.toString();
    }

    private String formatFrequencyBand(IFrequencyBand band) {
        StringBuilder sb = new StringBuilder();
        sb.append("BAND:").append(band.getIdentifier());
        sb.append(" ").append(band.isTDMA() ? "TDMA" : "FDMA");
        sb.append(" BASE:").append(band.getBaseFrequency());
        sb.append(" BANDWIDTH:").append(band.getBandwidth());
        sb.append(" SPACING:").append(band.getChannelSpacing());
        sb.append(" TRANSMIT OFFSET:").append(band.getTransmitOffset());
        if (band.isTDMA()) {
            sb.append(" TIMESLOTS:").append(band.getTimeslotCount());
        }
        return sb.toString();
    }
}

