/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase1;

import io.github.dsheirer.dsp.psk.pll.IPhaseLockedLoop;
import io.github.dsheirer.dsp.symbol.Dibit;
import io.github.dsheirer.dsp.symbol.ISyncDetectListener;
import io.github.dsheirer.edac.BCH_63_16_11;
import io.github.dsheirer.module.decode.p25.phase1.IP25P1DataUnitDetectListener;
import io.github.dsheirer.module.decode.p25.phase1.P25P1DataUnitID;
import io.github.dsheirer.module.decode.p25.phase1.P25P1SyncDetector;
import io.github.dsheirer.sample.Listener;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1DataUnitDetector
implements Listener<Dibit>,
ISyncDetectListener {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1DataUnitDetector.class);
    private static final int DATA_UNIT_DIBIT_LENGTH = 57;
    private static final int SYNC_DIBIT_LENGTH = 24;
    private static final int MAXIMUM_SYNC_MATCH_BIT_ERRORS = 9;
    private P25P1SyncDetector mSyncDetector;
    private NIDDelayBuffer mDataUnitBuffer = new NIDDelayBuffer(this);
    private DibitDelayBuffer mSyncDelayBuffer = new DibitDelayBuffer(this, 33);
    private IP25P1DataUnitDetectListener mDataUnitDetectListener;
    private boolean mInitialSyncTestProcessed = false;
    private int mDibitsProcessed = 0;
    private BCH_63_16_11 mNIDDecoder = new BCH_63_16_11();
    private P25P1DataUnitID mPreviousDataUnitId = P25P1DataUnitID.TERMINATOR_DATA_UNIT;
    private int mNIDDetectionCount;

    public P25P1DataUnitDetector(IP25P1DataUnitDetectListener dataUnitDetectListener, IPhaseLockedLoop phaseLockedLoop) {
        this.mDataUnitDetectListener = dataUnitDetectListener;
        this.mSyncDetector = new P25P1SyncDetector(this, phaseLockedLoop);
    }

    public void setSampleRate(double sampleRate) {
        this.mSyncDetector.setSampleRate(sampleRate);
    }

    public void reset() {
        this.mDibitsProcessed = 0;
        this.mInitialSyncTestProcessed = false;
    }

    @Override
    public void syncDetected(int bitErrors) {
        this.mInitialSyncTestProcessed = true;
        this.checkForNid(bitErrors, false);
    }

    @Override
    public void syncLost(int bitsProcessed) {
        this.dispatchSyncLoss(bitsProcessed);
    }

    private void dispatchSyncLoss(int bitsProcessed) {
        if (this.mDataUnitDetectListener != null) {
            this.mDataUnitDetectListener.syncLost(bitsProcessed);
        }
    }

    @Override
    public void receive(Dibit dibit) {
        ++this.mDibitsProcessed;
        if (this.mDibitsProcessed > 4864) {
            this.dispatchSyncLoss(9600);
            this.mDibitsProcessed -= 4800;
        }
        this.mDataUnitBuffer.put(dibit);
        this.mSyncDetector.receive(this.mSyncDelayBuffer.getAndPut(dibit));
        if (!this.mInitialSyncTestProcessed && this.mDibitsProcessed == 57) {
            this.mInitialSyncTestProcessed = true;
            this.checkForNid(this.mSyncDetector.getPrimarySyncMatchErrorCount(), true);
        }
    }

    private void checkForNid(int bitErrorCount, boolean forcedCheck) {
        if (bitErrorCount <= 9) {
            int[] correctedNid;
            int[] nid = this.mSyncDelayBuffer.getNID();
            if (!this.mNIDDecoder.decode(nid, correctedNid = new int[63])) {
                ++this.mNIDDetectionCount;
                int nidBitErrorCount = P25P1DataUnitDetector.getBitErrorCount(nid, correctedNid);
                if (this.mDataUnitDetectListener != null) {
                    this.mPreviousDataUnitId = this.getDataUnitID(correctedNid);
                    this.mDataUnitDetectListener.dataUnitDetected(this.mPreviousDataUnitId, this.getNAC(correctedNid), bitErrorCount + nidBitErrorCount, this.mDibitsProcessed - 57, correctedNid);
                }
            } else if (this.mPreviousDataUnitId == P25P1DataUnitID.LOGICAL_LINK_DATA_UNIT_1) {
                this.mDataUnitDetectListener.dataUnitDetected(P25P1DataUnitID.LOGICAL_LINK_DATA_UNIT_2, -1, bitErrorCount + 64, this.mDibitsProcessed - 57, new int[63]);
                this.mPreviousDataUnitId = P25P1DataUnitID.TERMINATOR_DATA_UNIT;
            } else if (this.mPreviousDataUnitId == P25P1DataUnitID.LOGICAL_LINK_DATA_UNIT_2) {
                this.mDataUnitDetectListener.dataUnitDetected(P25P1DataUnitID.LOGICAL_LINK_DATA_UNIT_1, -1, bitErrorCount + 64, this.mDibitsProcessed - 57, new int[63]);
                this.mPreviousDataUnitId = P25P1DataUnitID.TERMINATOR_DATA_UNIT;
            }
        }
    }

    public P25P1DataUnitID getDataUnitID(int[] nid) {
        int duid = 0;
        if (nid[47] == 1) {
            duid ^= 1;
        }
        if (nid[48] == 1) {
            duid ^= 2;
        }
        if (nid[49] == 1) {
            duid ^= 4;
        }
        if (nid[50] == 1) {
            duid ^= 8;
        }
        return P25P1DataUnitID.fromValue(duid);
    }

    public int getNAC(int[] nid) {
        int nac = 0;
        if (nid[51] == 1) {
            nac ^= 1;
        }
        if (nid[52] == 1) {
            nac ^= 2;
        }
        if (nid[53] == 1) {
            nac ^= 4;
        }
        if (nid[54] == 1) {
            nac ^= 8;
        }
        if (nid[55] == 1) {
            nac ^= 0x10;
        }
        if (nid[56] == 1) {
            nac ^= 0x20;
        }
        if (nid[57] == 1) {
            nac ^= 0x40;
        }
        if (nid[58] == 1) {
            nac ^= 0x80;
        }
        if (nid[59] == 1) {
            nac ^= 0x100;
        }
        if (nid[60] == 1) {
            nac ^= 0x200;
        }
        if (nid[61] == 1) {
            nac ^= 0x400;
        }
        if (nid[62] == 1) {
            nac ^= 0x800;
        }
        return nac;
    }

    public int getNIDDetectionCount() {
        return this.mNIDDetectionCount;
    }

    public static int[] reverse(int[] values) {
        int[] reversed = new int[values.length];
        for (int x = 0; x < values.length; ++x) {
            reversed[values.length - x - 1] = values[x];
        }
        return reversed;
    }

    public static void logNID(int[] nid, boolean corrected) {
        StringBuilder sb = new StringBuilder();
        for (int value : nid) {
            sb.append(value);
        }
        if (corrected) {
            mLog.debug("C* NID: " + String.valueOf(sb));
        } else {
            mLog.debug("   NID: " + String.valueOf(sb));
        }
    }

    public static int getBitErrorCount(int[] a, int[] b) {
        Validate.isTrue((a.length == b.length ? 1 : 0) != 0, (String)"Array lengths must be the same", (Object[])new Object[0]);
        int count = 0;
        for (int x = 0; x < a.length; ++x) {
            if (a[x] == b[x]) continue;
            ++count;
        }
        return count;
    }

    public class NIDDelayBuffer
    extends DibitDelayBuffer {
        public NIDDelayBuffer(P25P1DataUnitDetector this$0) {
            super(this$0, 57);
        }

        @Override
        public int[] getNID() {
            int[] nid = new int[64];
            int nidPointer = 0;
            int bufferPointer = this.mPointer;
            while (nidPointer < 64) {
                if (this.mBuffer[bufferPointer].getBit2()) {
                    nid[nidPointer] = 1;
                }
                ++nidPointer;
                if (this.mBuffer[bufferPointer].getBit1()) {
                    nid[nidPointer] = 1;
                }
                ++nidPointer;
                if (--bufferPointer < 0) {
                    bufferPointer += this.mBuffer.length;
                }
                if (nidPointer != 70) continue;
                nidPointer += 2;
            }
            return nid;
        }
    }

    public class DibitDelayBuffer {
        protected Dibit[] mBuffer;
        protected int mPointer;

        public DibitDelayBuffer(P25P1DataUnitDetector this$0, int length) {
            this.mBuffer = new Dibit[length];
            for (int x = 0; x < length; ++x) {
                this.mBuffer[x] = Dibit.D00_PLUS_1;
            }
        }

        public int[] getNID() {
            int[] nid = new int[63];
            int nidPointer = 0;
            int bufferPointer = this.mPointer - 1;
            if (bufferPointer < 0) {
                bufferPointer += this.mBuffer.length;
            }
            if (this.mBuffer[bufferPointer].getBit1()) {
                nid[nidPointer] = 1;
            }
            ++nidPointer;
            if (--bufferPointer < 0) {
                bufferPointer += this.mBuffer.length;
            }
            while (nidPointer < 63) {
                if (this.mBuffer[bufferPointer].getBit2()) {
                    nid[nidPointer] = 1;
                }
                ++nidPointer;
                if (this.mBuffer[bufferPointer].getBit1()) {
                    nid[nidPointer] = 1;
                }
                --bufferPointer;
                if (++nidPointer == 41) {
                    --bufferPointer;
                }
                if (bufferPointer >= 0) continue;
                bufferPointer += this.mBuffer.length;
            }
            return nid;
        }

        public void log() {
            StringBuilder sb = new StringBuilder();
            int pointer = this.mPointer;
            for (int counter = 0; counter < this.mBuffer.length; ++counter) {
                sb.append(this.mBuffer[pointer].getBit1() ? "1" : "0");
                sb.append(this.mBuffer[pointer++].getBit2() ? "1" : "0");
                if (pointer < this.mBuffer.length) continue;
                pointer = 0;
            }
            if (this instanceof NIDDelayBuffer) {
                mLog.debug("NIDBUF: " + String.valueOf(sb) + " Length:" + this.mBuffer.length);
            } else {
                mLog.debug("SYNBUF: " + String.valueOf(sb) + " Length:" + this.mBuffer.length);
            }
        }

        public Dibit[] getBuffer() {
            Dibit[] transferBuffer = new Dibit[this.mBuffer.length];
            int transferBufferPointer = 0;
            int bufferPointer = this.mPointer;
            while (transferBufferPointer < transferBuffer.length) {
                transferBuffer[transferBufferPointer++] = this.mBuffer[bufferPointer++];
                if (bufferPointer < this.mBuffer.length) continue;
                bufferPointer = 0;
            }
            return transferBuffer;
        }

        public int[] getBufferAsArray() {
            Dibit[] dibits = this.getBuffer();
            int[] bits = new int[dibits.length * 2];
            for (int x = 0; x < dibits.length; ++x) {
                if (dibits[x].getBit1()) {
                    bits[x * 2] = 1;
                }
                if (!dibits[x].getBit2()) continue;
                bits[x * 2 + 1] = 1;
            }
            return bits;
        }

        public void put(Dibit dibit) {
            if (this.mPointer >= this.mBuffer.length) {
                this.mPointer = 0;
            }
            this.mBuffer[this.mPointer++] = dibit;
            if (this.mPointer >= this.mBuffer.length) {
                this.mPointer = 0;
            }
        }

        public Dibit getAndPut(Dibit dibit) {
            Dibit toReturn = this.mBuffer[this.mPointer];
            this.put(dibit);
            return toReturn;
        }
    }
}

