/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.identifier.channel;

import io.github.dsheirer.module.decode.p25.identifier.channel.P25Channel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBand;

public class P25ExplicitChannel
extends P25Channel
implements Comparable<P25Channel> {
    private IFrequencyBand mUplinkFrequencyBand;
    private int mUplinkBandIdentifier;
    private int mUplinkChannelNumber;

    public P25ExplicitChannel(int downlinkBandIdentifier, int downlinkChannelNumber, int uplinkBandIdentifier, int uplinkChannelNumber) {
        super(downlinkBandIdentifier, downlinkChannelNumber);
        this.mUplinkBandIdentifier = uplinkBandIdentifier;
        this.mUplinkChannelNumber = uplinkChannelNumber;
    }

    @Override
    public int getUplinkBandIdentifier() {
        return this.mUplinkBandIdentifier;
    }

    @Override
    public int getUplinkChannelNumber() {
        return this.mUplinkChannelNumber;
    }

    @Override
    public long getUplinkFrequency() {
        if (this.mUplinkFrequencyBand != null) {
            return this.mUplinkFrequencyBand.getDownlinkFrequency(this.getUplinkChannelNumber());
        }
        return 0L;
    }

    @Override
    public void setFrequencyBand(IFrequencyBand frequencyBand) {
        if (frequencyBand.getIdentifier() == this.getUplinkBandIdentifier()) {
            this.mUplinkFrequencyBand = frequencyBand;
        }
        super.setFrequencyBand(frequencyBand);
    }

    @Override
    public int compareTo(P25Channel other) {
        if (this.getDownlinkBandIdentifier() == other.getDownlinkBandIdentifier()) {
            return Integer.compare(this.getDownlinkChannelNumber(), other.getDownlinkChannelNumber());
        }
        return Integer.compare(this.getDownlinkBandIdentifier(), other.getDownlinkBandIdentifier());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof P25ExplicitChannel)) {
            return false;
        }
        return this.compareTo((P25ExplicitChannel)o) == 0;
    }
}

