/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.audio;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonRootName;

@JsonRootName(value="frame")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"encryption_algorithm", "encryption_key_id", "encryption_mi", "time", "hex"})
public class VoiceFrame {
    private long mTimestamp;
    private String mFrame;
    private Integer mAlgorithm;
    private Integer mKeyId;
    private String mMessageIndicator;

    public VoiceFrame() {
    }

    public VoiceFrame(long timestamp, String frame) {
        this.mTimestamp = timestamp;
        this.mFrame = frame;
    }

    public VoiceFrame(long timestamp, String frame, int algorithm, int keyid, String messageIndicator) {
        this(timestamp, frame);
        this.mAlgorithm = algorithm;
        this.mKeyId = keyid;
        this.mMessageIndicator = messageIndicator;
    }

    @JsonProperty(value="time")
    public long getTimestamp() {
        return this.mTimestamp;
    }

    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    @JsonProperty(value="hex")
    public String getFrame() {
        return this.mFrame;
    }

    public void setFrame(String frame) {
        this.mFrame = frame;
    }

    @JsonIgnore
    public byte[] getFrameBytes() {
        if (this.mFrame != null) {
            byte[] bytes = new byte[this.mFrame.length() / 2];
            for (int x = 0; x < this.mFrame.length(); x += 2) {
                String hex = this.mFrame.substring(x, x + 2);
                bytes[x / 2] = (byte)(0xFF & Integer.parseInt(hex, 16));
            }
            return bytes;
        }
        return null;
    }

    @JsonProperty(value="encryption_algorithm")
    public Integer getAlgorithm() {
        return this.mAlgorithm;
    }

    public void setAlgorithm(int algorithm) {
        this.mAlgorithm = algorithm;
    }

    @JsonProperty(value="encryption_key_id")
    public Integer getKeyId() {
        return this.mKeyId;
    }

    public void setKeyId(int keyId) {
        this.mKeyId = keyId;
    }

    @JsonProperty(value="encryption_mi")
    public String getMessageIndicator() {
        return this.mMessageIndicator;
    }

    public void setMessageIndicator(String messageIndicator) {
        this.mMessageIndicator = messageIndicator;
    }
}

