/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.audio;

import io.github.dsheirer.audio.codec.mbe.MBECallSequence;
import io.github.dsheirer.audio.codec.mbe.MBECallSequenceRecorder;
import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.P25P2Message;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.EndPushToTalk;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelUserAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.GroupVoiceChannelUserExtended;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.PushToTalk;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.TelephoneInterconnectVoiceChannelUser;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitVoiceChannelUserAbbreviated;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.structure.UnitToUnitVoiceChannelUserExtended;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractVoiceTimeslot;
import io.github.dsheirer.preference.UserPreferences;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P2CallSequenceRecorder
extends MBECallSequenceRecorder {
    private static final Logger mLog = LoggerFactory.getLogger(P25P2CallSequenceRecorder.class);
    private static final String PROTOCOL = "APCO25-PHASE2";
    private TimeslotCallSequenceProcessor mTimeslot0Processor = new TimeslotCallSequenceProcessor(0);
    private TimeslotCallSequenceProcessor mTimeslot1Processor = new TimeslotCallSequenceProcessor(1);

    public P25P2CallSequenceRecorder(UserPreferences userPreferences, long channelFrequency, String system, String site) {
        super(userPreferences, channelFrequency, system, site);
    }

    @Override
    public void stop() {
        this.mTimeslot0Processor.flush();
        this.mTimeslot1Processor.flush();
    }

    @Override
    public void receive(IMessage message) {
        P25P2Message p25p2;
        if (message instanceof P25P2Message && (p25p2 = (P25P2Message)message).isValid()) {
            switch (p25p2.getTimeslot()) {
                case 0: {
                    this.mTimeslot0Processor.process(p25p2);
                    break;
                }
                case 1: {
                    this.mTimeslot1Processor.process(p25p2);
                }
            }
        }
    }

    class TimeslotCallSequenceProcessor {
        private int mTimeslot;
        private MBECallSequence mCallSequence;

        public TimeslotCallSequenceProcessor(int timeslot) {
            this.mTimeslot = timeslot;
        }

        public int getTimeslot() {
            return this.mTimeslot;
        }

        public void flush() {
            if (this.mCallSequence != null) {
                P25P2CallSequenceRecorder.this.writeCallSequence(this.mCallSequence, "TS" + this.getTimeslot());
                this.mCallSequence = null;
            }
        }

        public void process(P25P2Message message) {
            if (message instanceof AbstractVoiceTimeslot) {
                this.process((AbstractVoiceTimeslot)message);
            } else if (message instanceof MacMessage) {
                this.process((MacMessage)message);
            }
        }

        private void process(AbstractVoiceTimeslot voiceTimeslot) {
            if (this.mCallSequence == null) {
                this.mCallSequence = new MBECallSequence(P25P2CallSequenceRecorder.PROTOCOL);
            }
            List<BinaryMessage> voiceFrames = voiceTimeslot.getVoiceFrames();
            long baseTimestamp = voiceTimeslot.getTimestamp();
            for (BinaryMessage frame : voiceFrames) {
                this.mCallSequence.addVoiceFrame(baseTimestamp, frame.toHexString());
                baseTimestamp += 20L;
            }
        }

        private void process(MacMessage macMessage) {
            switch (macMessage.getMacPduType()) {
                case MAC_1_PTT: 
                case MAC_4_ACTIVE: {
                    this.process(macMessage.getMacStructure(), true);
                    break;
                }
                case MAC_2_END_PTT: 
                case MAC_6_HANGTIME: {
                    this.process(macMessage.getMacStructure(), false);
                    break;
                }
                case MAC_3_IDLE: {
                    this.flush();
                }
            }
        }

        private void process(MacStructure mac, boolean isActive) {
            if (this.mCallSequence == null && isActive) {
                this.mCallSequence = new MBECallSequence(P25P2CallSequenceRecorder.PROTOCOL);
            }
            if (this.mCallSequence != null) {
                switch (mac.getOpcode()) {
                    case PUSH_TO_TALK: {
                        this.processPTT(mac);
                        break;
                    }
                    case END_PUSH_TO_TALK: {
                        this.processEndPTT(mac);
                        break;
                    }
                    case TDMA_1_GROUP_VOICE_CHANNEL_USER_ABBREVIATED: {
                        this.processGVCUA(mac);
                        break;
                    }
                    case TDMA_2_UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                        this.processUTUVCU(mac);
                        break;
                    }
                    case TDMA_3_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_USER: {
                        this.processTIVCU(mac);
                        break;
                    }
                    case TDMA_33_GROUP_VOICE_CHANNEL_USER_EXTENDED: {
                        this.processGVCUE(mac);
                        break;
                    }
                    case TDMA_34_UNIT_TO_UNIT_VOICE_CHANNEL_USER_EXTENDED: {
                        this.processUTUVCUE(mac);
                    }
                }
                if (!isActive) {
                    P25P2CallSequenceRecorder.this.writeCallSequence(this.mCallSequence, "TS" + this.getTimeslot());
                    this.mCallSequence = null;
                }
            }
        }

        private void processUTUVCUE(MacStructure mac) {
            if (mac instanceof UnitToUnitVoiceChannelUserExtended) {
                UnitToUnitVoiceChannelUserExtended uuvcue = (UnitToUnitVoiceChannelUserExtended)mac;
                this.mCallSequence.setFromIdentifier(uuvcue.getSourceAddress().toString());
                this.mCallSequence.setToIdentifier(uuvcue.getTargetAddress().toString());
                this.mCallSequence.setCallType("INDIVIDUAL");
                if (uuvcue.getServiceOptions().isEncrypted()) {
                    this.mCallSequence.setEncrypted(true);
                }
            } else {
                mLog.warn("Expected unit-2-unit voice channel user extended but found: " + String.valueOf(mac.getClass()));
            }
        }

        private void processGVCUE(MacStructure mac) {
            if (mac instanceof GroupVoiceChannelUserExtended) {
                GroupVoiceChannelUserExtended gvcue = (GroupVoiceChannelUserExtended)mac;
                this.mCallSequence.setFromIdentifier(gvcue.getSourceAddress().toString());
                this.mCallSequence.setToIdentifier(gvcue.getGroupAddress().toString());
                this.mCallSequence.setCallType("GROUP");
                if (gvcue.getServiceOptions().isEncrypted()) {
                    this.mCallSequence.setEncrypted(true);
                }
            } else {
                mLog.warn("Expected group voice channel user extended but found: " + String.valueOf(mac.getClass()));
            }
        }

        private void processTIVCU(MacStructure mac) {
            if (mac instanceof TelephoneInterconnectVoiceChannelUser) {
                TelephoneInterconnectVoiceChannelUser tivcu = (TelephoneInterconnectVoiceChannelUser)mac;
                this.mCallSequence.setToIdentifier(tivcu.getToOrFromAddress().toString());
                this.mCallSequence.setCallType("TELEPHONE INTERCONNECT");
                if (tivcu.getServiceOptions().isEncrypted()) {
                    this.mCallSequence.setEncrypted(true);
                }
            } else {
                mLog.warn("Expected telephone interconnect voice channel user abbreviated but found: " + String.valueOf(mac.getClass()));
            }
        }

        private void processUTUVCU(MacStructure mac) {
            if (mac instanceof UnitToUnitVoiceChannelUserAbbreviated) {
                UnitToUnitVoiceChannelUserAbbreviated uuvcua = (UnitToUnitVoiceChannelUserAbbreviated)mac;
                this.mCallSequence.setFromIdentifier(uuvcua.getSourceAddress().toString());
                this.mCallSequence.setToIdentifier(uuvcua.getTargetAddress().toString());
                this.mCallSequence.setCallType("INDIVIDUAL");
                if (uuvcua.getServiceOptions().isEncrypted()) {
                    this.mCallSequence.setEncrypted(true);
                }
            } else {
                mLog.warn("Expected unit-2-unit voice channel user abbreviated but found: " + String.valueOf(mac.getClass()));
            }
        }

        private void processGVCUA(MacStructure mac) {
            if (mac instanceof GroupVoiceChannelUserAbbreviated) {
                GroupVoiceChannelUserAbbreviated gvcua = (GroupVoiceChannelUserAbbreviated)mac;
                this.mCallSequence.setFromIdentifier(gvcua.getSourceAddress().toString());
                this.mCallSequence.setToIdentifier(gvcua.getGroupAddress().toString());
                this.mCallSequence.setCallType("GROUP");
                if (gvcua.getServiceOptions().isEncrypted()) {
                    this.mCallSequence.setEncrypted(true);
                }
            } else {
                mLog.warn("Expected group voice channel user abbreviated but found: " + String.valueOf(mac.getClass()));
            }
        }

        private void processEndPTT(MacStructure mac) {
            if (mac instanceof EndPushToTalk) {
                EndPushToTalk eptt = (EndPushToTalk)mac;
                String source = eptt.getSourceAddress().toString();
                if (source != null && !source.contentEquals("16777215")) {
                    this.mCallSequence.setFromIdentifier(source);
                }
                this.mCallSequence.setToIdentifier(eptt.getGroupAddress().toString());
                P25P2CallSequenceRecorder.this.writeCallSequence(this.mCallSequence, "TS" + this.getTimeslot());
                this.mCallSequence = null;
            } else {
                mLog.warn("Expected End push-to-talk structure but found: " + String.valueOf(mac.getClass()));
            }
        }

        private void processPTT(MacStructure mac) {
            if (mac instanceof PushToTalk) {
                PushToTalk ptt = (PushToTalk)mac;
                if (this.mCallSequence == null) {
                    this.mCallSequence = new MBECallSequence(P25P2CallSequenceRecorder.PROTOCOL);
                }
                this.mCallSequence.setFromIdentifier(ptt.getSourceAddress().toString());
                this.mCallSequence.setToIdentifier(ptt.getGroupAddress().toString());
                if (ptt.isEncrypted()) {
                    this.mCallSequence.setEncrypted(true);
                    this.mCallSequence.setEncryptionSyncParameters(ptt.getEncryptionSyncParameters());
                }
            } else {
                mLog.warn("Expected push-to-talk structure but found: " + String.valueOf(mac.getClass()));
            }
        }
    }
}

