/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.audio;

import io.github.dsheirer.audio.codec.mbe.MBECallSequence;
import io.github.dsheirer.audio.codec.mbe.MBECallSequenceRecorder;
import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.P25Message;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.LinkControlWord;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola.LCMotorolaPatchGroupVoiceChannelUpdate;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.motorola.LCMotorolaPatchGroupVoiceChannelUser;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCGroupVoiceChannelUpdateExplicit;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCGroupVoiceChannelUser;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCTelephoneInterconnectVoiceChannelUser;
import io.github.dsheirer.module.decode.p25.phase1.message.lc.standard.LCUnitToUnitVoiceChannelUser;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.EncryptionSyncParameters;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU1Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDU2Message;
import io.github.dsheirer.module.decode.p25.phase1.message.ldu.LDUMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDULinkControlMessage;
import io.github.dsheirer.module.decode.p25.phase1.message.tdu.TDUMessage;
import io.github.dsheirer.preference.UserPreferences;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25P1CallSequenceRecorder
extends MBECallSequenceRecorder {
    private static final Logger mLog = LoggerFactory.getLogger(P25P1CallSequenceRecorder.class);
    public static final String PROTOCOL = "APCO25-PHASE1";
    private MBECallSequence mCallSequence;

    public P25P1CallSequenceRecorder(UserPreferences userPreferences, long channelFrequency, String system, String site) {
        super(userPreferences, channelFrequency, system, site);
    }

    @Override
    public void stop() {
        this.flush();
    }

    @Override
    public void receive(IMessage message) {
        P25Message p25;
        if (message instanceof P25Message && (p25 = (P25Message)message).isValid()) {
            this.process(p25);
        }
    }

    public void flush() {
        if (this.mCallSequence != null) {
            this.writeCallSequence(this.mCallSequence);
            this.mCallSequence = null;
        }
    }

    public void process(P25Message message) {
        if (message instanceof LDUMessage) {
            this.process((LDUMessage)message);
        } else if (message instanceof TDULinkControlMessage) {
            this.process((TDULinkControlMessage)message);
        } else if (message instanceof TDUMessage) {
            this.flush();
        }
    }

    private void process(TDULinkControlMessage tdulc) {
        this.process(tdulc.getLinkControlWord());
    }

    private void process(LDUMessage lduMessage) {
        if (this.mCallSequence == null) {
            this.mCallSequence = new MBECallSequence(PROTOCOL);
        }
        if (lduMessage instanceof LDU1Message) {
            this.process((LDU1Message)lduMessage);
        } else if (lduMessage instanceof LDU2Message) {
            this.process((LDU2Message)lduMessage);
        }
        List<byte[]> voiceFrames = lduMessage.getIMBEFrames();
        long baseTimestamp = lduMessage.getTimestamp();
        for (byte[] frame : voiceFrames) {
            BinaryMessage frameBits = BinaryMessage.from(frame);
            this.mCallSequence.addVoiceFrame(baseTimestamp, frameBits.toHexString());
            baseTimestamp += 20L;
        }
    }

    private void process(LinkControlWord lcw) {
        if (lcw.isValid() && this.mCallSequence != null) {
            switch (lcw.getOpcode()) {
                case GROUP_VOICE_CHANNEL_USER: {
                    LCGroupVoiceChannelUser gvcu = (LCGroupVoiceChannelUser)lcw;
                    this.mCallSequence.setFromIdentifier(gvcu.getSourceAddress().toString());
                    this.mCallSequence.setToIdentifier(gvcu.getGroupAddress().toString());
                    this.mCallSequence.setCallType("GROUP");
                    break;
                }
                case UNIT_TO_UNIT_VOICE_CHANNEL_USER: {
                    LCUnitToUnitVoiceChannelUser uuvcu = (LCUnitToUnitVoiceChannelUser)lcw;
                    this.mCallSequence.setFromIdentifier(uuvcu.getSourceAddress().toString());
                    this.mCallSequence.setToIdentifier(uuvcu.getTargetAddress().toString());
                    this.mCallSequence.setCallType("INDIVIDUAL");
                    break;
                }
                case GROUP_VOICE_CHANNEL_UPDATE_EXPLICIT: {
                    LCGroupVoiceChannelUpdateExplicit gvcue = (LCGroupVoiceChannelUpdateExplicit)lcw;
                    this.mCallSequence.setToIdentifier(gvcue.getGroupAddress().toString());
                    this.mCallSequence.setCallType("GROUP");
                    break;
                }
                case TELEPHONE_INTERCONNECT_VOICE_CHANNEL_USER: {
                    LCTelephoneInterconnectVoiceChannelUser tivcu = (LCTelephoneInterconnectVoiceChannelUser)lcw;
                    this.mCallSequence.setToIdentifier(tivcu.getAddress().toString());
                    this.mCallSequence.setCallType("TELEPHONE INTERCONNECT");
                    break;
                }
                case MOTOROLA_PATCH_GROUP_VOICE_CHANNEL_USER: {
                    LCMotorolaPatchGroupVoiceChannelUser mpgvcu = (LCMotorolaPatchGroupVoiceChannelUser)lcw;
                    this.mCallSequence.setFromIdentifier(mpgvcu.getSourceAddress().toString());
                    this.mCallSequence.setToIdentifier(mpgvcu.getGroupAddress().toString());
                    this.mCallSequence.setCallType("GROUP");
                    break;
                }
                case MOTOROLA_PATCH_GROUP_VOICE_CHANNEL_UPDATE: {
                    LCMotorolaPatchGroupVoiceChannelUpdate mpgvcup = (LCMotorolaPatchGroupVoiceChannelUpdate)lcw;
                    this.mCallSequence.setToIdentifier(mpgvcup.getPatchGroup().toString());
                    this.mCallSequence.setCallType("GROUP");
                    break;
                }
                case CALL_TERMINATION_OR_CANCELLATION: 
                case MOTOROLA_TALK_COMPLETE: {
                    this.writeCallSequence(this.mCallSequence);
                    this.mCallSequence = null;
                }
            }
        }
    }

    private void process(LDU1Message ldu1Message) {
        this.process(ldu1Message.getLinkControlWord());
    }

    private void process(LDU2Message ldu2Message) {
        EncryptionSyncParameters parameters = ldu2Message.getEncryptionSyncParameters();
        if (parameters.isValid() && parameters.isEncryptedAudio()) {
            this.mCallSequence.setEncrypted(true);
            this.mCallSequence.setEncryptionSyncParameters(parameters);
        }
    }
}

