/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.IChannelEventListener;
import io.github.dsheirer.controller.channel.IChannelEventProvider;
import io.github.dsheirer.controller.channel.event.ChannelStartProcessingRequest;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.MutableIdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.patch.PatchGroupPreLoadDataContent;
import io.github.dsheirer.identifier.scramble.ScrambleParameterIdentifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.IMessageListener;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.IDecodeEventProvider;
import io.github.dsheirer.module.decode.p25.P25ChannelGrantEvent;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25ExplicitChannel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25P2Channel;
import io.github.dsheirer.module.decode.p25.identifier.channel.P25P2ExplicitChannel;
import io.github.dsheirer.module.decode.p25.phase1.DecodeConfigP25Phase1;
import io.github.dsheirer.module.decode.p25.phase1.message.pdu.ambtc.osp.AMBTCNetworkStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.Opcode;
import io.github.dsheirer.module.decode.p25.phase1.message.tsbk.standard.osp.NetworkStatusBroadcast;
import io.github.dsheirer.module.decode.p25.phase2.DecodeConfigP25Phase2;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.ScrambleParameters;
import io.github.dsheirer.module.decode.p25.reference.ServiceOptions;
import io.github.dsheirer.module.decode.traffic.TrafficChannelManager;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.config.SourceConfigTuner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P25TrafficChannelManager
extends TrafficChannelManager
implements IDecodeEventProvider,
IChannelEventListener,
IChannelEventProvider,
IMessageListener {
    private static final Logger mLog = LoggerFactory.getLogger(P25TrafficChannelManager.class);
    public static final String CHANNEL_START_REJECTED = "CHANNEL START REJECTED";
    public static final String MAX_TRAFFIC_CHANNELS_EXCEEDED = "MAX TRAFFIC CHANNELS EXCEEDED";
    private Queue<Channel> mAvailablePhase1TrafficChannelQueue = new ConcurrentLinkedQueue<Channel>();
    private List<Channel> mManagedPhase1TrafficChannels;
    private Queue<Channel> mAvailablePhase2TrafficChannelQueue = new ConcurrentLinkedQueue<Channel>();
    private List<Channel> mManagedPhase2TrafficChannels;
    private Map<Long, Channel> mAllocatedTrafficChannelMap = new ConcurrentHashMap<Long, Channel>();
    private Map<Long, P25ChannelGrantEvent> mTS0ChannelGrantEventMap = new ConcurrentHashMap<Long, P25ChannelGrantEvent>();
    private Map<Long, P25ChannelGrantEvent> mTS1ChannelGrantEventMap = new ConcurrentHashMap<Long, P25ChannelGrantEvent>();
    private Listener<ChannelEvent> mChannelEventListener;
    private Listener<IDecodeEvent> mDecodeEventListener;
    private TrafficChannelTeardownMonitor mTrafficChannelTeardownMonitor = new TrafficChannelTeardownMonitor();
    private Channel mParentChannel;
    private ScrambleParameters mPhase2ScrambleParameters;
    private Listener<IMessage> mMessageListener;
    private boolean mIgnoreDataCalls;

    public P25TrafficChannelManager(Channel parentChannel) {
        this.mParentChannel = parentChannel;
        if (parentChannel.getDecodeConfiguration() instanceof DecodeConfigP25Phase1) {
            this.mIgnoreDataCalls = ((DecodeConfigP25Phase1)parentChannel.getDecodeConfiguration()).getIgnoreDataCalls();
        }
        this.createPhase1TrafficChannels();
        this.createPhase2TrafficChannels();
    }

    private void createPhase1TrafficChannels() {
        if (this.mManagedPhase1TrafficChannels == null) {
            DecodeConfigP25Phase1 p25DecodeConfig;
            int maxTrafficChannels;
            DecodeConfiguration decodeConfiguration = this.mParentChannel.getDecodeConfiguration();
            ArrayList<Channel> trafficChannelList = new ArrayList<Channel>();
            if (decodeConfiguration instanceof DecodeConfigP25Phase1 && (maxTrafficChannels = (p25DecodeConfig = (DecodeConfigP25Phase1)decodeConfiguration).getTrafficChannelPoolSize()) > 0) {
                for (int x = 0; x < maxTrafficChannels; ++x) {
                    Channel trafficChannel = new Channel("T-" + this.mParentChannel.getName(), Channel.ChannelType.TRAFFIC);
                    trafficChannel.setAliasListName(this.mParentChannel.getAliasListName());
                    trafficChannel.setSystem(this.mParentChannel.getSystem());
                    trafficChannel.setSite(this.mParentChannel.getSite());
                    trafficChannel.setDecodeConfiguration(p25DecodeConfig);
                    trafficChannel.setEventLogConfiguration(this.mParentChannel.getEventLogConfiguration());
                    trafficChannel.setRecordConfiguration(this.mParentChannel.getRecordConfiguration());
                    trafficChannelList.add(trafficChannel);
                }
            }
            this.mAvailablePhase1TrafficChannelQueue.addAll(trafficChannelList);
            this.mManagedPhase1TrafficChannels = Collections.unmodifiableList(trafficChannelList);
        }
    }

    private void createPhase2TrafficChannels() {
        if (this.mManagedPhase2TrafficChannels == null) {
            DecodeConfigP25Phase1 p25DecodeConfig;
            int maxTrafficChannels;
            DecodeConfiguration decodeConfiguration = this.mParentChannel.getDecodeConfiguration();
            ArrayList<Channel> trafficChannelList = new ArrayList<Channel>();
            if (decodeConfiguration instanceof DecodeConfigP25Phase1 && (maxTrafficChannels = (p25DecodeConfig = (DecodeConfigP25Phase1)decodeConfiguration).getTrafficChannelPoolSize()) > 0) {
                for (int x = 0; x < maxTrafficChannels; ++x) {
                    Channel trafficChannel = new Channel("T-" + this.mParentChannel.getName(), Channel.ChannelType.TRAFFIC);
                    trafficChannel.setAliasListName(this.mParentChannel.getAliasListName());
                    trafficChannel.setSystem(this.mParentChannel.getSystem());
                    trafficChannel.setSite(this.mParentChannel.getSite());
                    trafficChannel.setDecodeConfiguration(new DecodeConfigP25Phase2());
                    trafficChannel.setEventLogConfiguration(this.mParentChannel.getEventLogConfiguration());
                    trafficChannel.setRecordConfiguration(this.mParentChannel.getRecordConfiguration());
                    trafficChannelList.add(trafficChannel);
                }
            }
            this.mAvailablePhase2TrafficChannelQueue.addAll(trafficChannelList);
            this.mManagedPhase2TrafficChannels = Collections.unmodifiableList(trafficChannelList);
        }
    }

    public void broadcast(DecodeEvent decodeEvent) {
        if (this.mDecodeEventListener != null) {
            this.mDecodeEventListener.receive(decodeEvent);
        }
    }

    public void processChannelGrant(APCO25Channel apco25Channel, ServiceOptions serviceOptions, IdentifierCollection identifierCollection, Opcode opcode, long timestamp) {
        if (apco25Channel.isTDMAChannel()) {
            if (apco25Channel.getTimeslotCount() == 2) {
                if (opcode.isDataChannelGrant()) {
                    APCO25Channel phase1Channel = P25TrafficChannelManager.convertPhase2ToPhase1(apco25Channel);
                    this.processPhase1ChannelGrant(phase1Channel, serviceOptions, identifierCollection, opcode, timestamp);
                } else {
                    this.processPhase2ChannelGrant(apco25Channel, serviceOptions, identifierCollection, opcode, timestamp);
                }
            } else {
                mLog.warn("Cannot process TDMA channel grant - unrecognized timeslot count: " + apco25Channel.getTimeslotCount());
            }
        } else {
            this.processPhase1ChannelGrant(apco25Channel, serviceOptions, identifierCollection, opcode, timestamp);
        }
    }

    private void processPhase1ChannelGrant(APCO25Channel apco25Channel, ServiceOptions serviceOptions, IdentifierCollection identifierCollection, Opcode opcode, long timestamp) {
        long frequency = apco25Channel.getDownlinkFrequency();
        DecodeEventType decodeEventType = this.getEventType(opcode, serviceOptions);
        P25ChannelGrantEvent event = this.mTS0ChannelGrantEventMap.get(frequency);
        if (event != null && this.isSameCall(identifierCollection, event.getIdentifierCollection())) {
            Channel trafficChannel;
            Identifier currentFrom;
            Identifier from = this.getIdentifier(identifierCollection, Role.FROM);
            if (from != null && (currentFrom = this.getIdentifier(event.getIdentifierCollection(), Role.FROM)) != null && !Objects.equals(from, currentFrom)) {
                event.end(timestamp);
                P25ChannelGrantEvent continuationGrantEvent = P25ChannelGrantEvent.builder(decodeEventType, timestamp, serviceOptions).channel(apco25Channel).details("CONTINUE - PHASE 1 CHANNEL GRANT " + String.valueOf(serviceOptions != null ? serviceOptions : "")).identifiers(identifierCollection).build();
                this.mTS0ChannelGrantEventMap.put(frequency, continuationGrantEvent);
                this.broadcast(continuationGrantEvent);
            }
            event.update(timestamp);
            this.broadcast(event);
            if (!(this.mAllocatedTrafficChannelMap.containsKey(frequency) || this.mIgnoreDataCalls && opcode.isDataChannelGrant() || (trafficChannel = this.mAvailablePhase1TrafficChannelQueue.poll()) == null)) {
                event.setDetails("PHASE 1 CHANNEL GRANT " + String.valueOf(serviceOptions != null ? serviceOptions : ""));
                event.setChannelDescriptor(apco25Channel);
                this.broadcast(event);
                SourceConfigTuner sourceConfig = new SourceConfigTuner();
                sourceConfig.setFrequency(frequency);
                trafficChannel.setSourceConfiguration(sourceConfig);
                this.mAllocatedTrafficChannelMap.put(frequency, trafficChannel);
                ChannelStartProcessingRequest startChannelRequest = new ChannelStartProcessingRequest(trafficChannel, apco25Channel, identifierCollection);
                startChannelRequest.addPreloadDataContent(new PatchGroupPreLoadDataContent(identifierCollection));
                this.getInterModuleEventBus().post((Object)startChannelRequest);
            }
            return;
        }
        if (this.mIgnoreDataCalls && opcode.isDataChannelGrant()) {
            P25ChannelGrantEvent channelGrantEvent = P25ChannelGrantEvent.builder(decodeEventType, timestamp, serviceOptions).channel(apco25Channel).details("DATA CALL IGNORED: " + String.valueOf(serviceOptions != null ? serviceOptions : "")).identifiers(identifierCollection).build();
            this.mTS0ChannelGrantEventMap.put(frequency, channelGrantEvent);
            this.broadcast(channelGrantEvent);
            return;
        }
        P25ChannelGrantEvent channelGrantEvent = P25ChannelGrantEvent.builder(decodeEventType, timestamp, serviceOptions).channel(apco25Channel).details("PHASE 1 CHANNEL GRANT " + String.valueOf(serviceOptions != null ? serviceOptions : "")).identifiers(identifierCollection).build();
        this.mTS0ChannelGrantEventMap.put(frequency, channelGrantEvent);
        if (!this.mAllocatedTrafficChannelMap.containsKey(frequency)) {
            Channel trafficChannel = this.mAvailablePhase1TrafficChannelQueue.poll();
            if (trafficChannel == null) {
                channelGrantEvent.setDetails("MAX TRAFFIC CHANNELS EXCEEDED - IGNORED");
                return;
            }
            SourceConfigTuner sourceConfig = new SourceConfigTuner();
            sourceConfig.setFrequency(frequency);
            trafficChannel.setSourceConfiguration(sourceConfig);
            this.mAllocatedTrafficChannelMap.put(frequency, trafficChannel);
            ChannelStartProcessingRequest startChannelRequest = new ChannelStartProcessingRequest(trafficChannel, apco25Channel, identifierCollection);
            startChannelRequest.addPreloadDataContent(new PatchGroupPreLoadDataContent(identifierCollection));
            this.getInterModuleEventBus().post((Object)startChannelRequest);
        }
        this.broadcast(channelGrantEvent);
    }

    private void processPhase2ChannelGrant(APCO25Channel apco25Channel, ServiceOptions serviceOptions, IdentifierCollection identifierCollection, Opcode opcode, long timestamp) {
        if (this.mPhase2ScrambleParameters != null && identifierCollection instanceof MutableIdentifierCollection) {
            ((MutableIdentifierCollection)identifierCollection).silentUpdate(ScrambleParameterIdentifier.create(this.mPhase2ScrambleParameters));
        }
        int timeslot = apco25Channel.getTimeslot();
        long frequency = apco25Channel.getDownlinkFrequency();
        P25ChannelGrantEvent event = null;
        if (timeslot == 0) {
            event = this.mTS0ChannelGrantEventMap.get(frequency);
        } else if (timeslot == 1) {
            event = this.mTS1ChannelGrantEventMap.get(frequency);
        } else {
            mLog.error("Ignoring: Invalid timeslot [" + timeslot + "] detected for P25 Phase 2 Channel Grant.");
            return;
        }
        identifierCollection.setTimeslot(timeslot);
        DecodeEventType decodeEventType = this.getEventType(opcode, serviceOptions);
        if (event != null && this.isSameCall(identifierCollection, event.getIdentifierCollection())) {
            Channel trafficChannel;
            Identifier currentFrom;
            Identifier from = this.getIdentifier(identifierCollection, Role.FROM);
            if (from != null && (currentFrom = this.getIdentifier(event.getIdentifierCollection(), Role.FROM)) != null && !Objects.equals(from, currentFrom)) {
                event.end(timestamp);
                P25ChannelGrantEvent continuationGrantEvent = P25ChannelGrantEvent.builder(decodeEventType, timestamp, serviceOptions).channel(apco25Channel).details("CONTINUE - PHASE 2 CHANNEL GRANT " + String.valueOf(serviceOptions != null ? serviceOptions : "")).identifiers(identifierCollection).build();
                if (timeslot == 0) {
                    this.mTS0ChannelGrantEventMap.put(frequency, continuationGrantEvent);
                } else {
                    this.mTS1ChannelGrantEventMap.put(frequency, continuationGrantEvent);
                }
                this.broadcast(continuationGrantEvent);
            }
            event.update(timestamp);
            this.broadcast(event);
            if (!(this.mAllocatedTrafficChannelMap.containsKey(frequency) || this.mIgnoreDataCalls && opcode.isDataChannelGrant() || (trafficChannel = this.mAvailablePhase2TrafficChannelQueue.poll()) == null)) {
                event.setDetails("PHASE 2 CHANNEL GRANT " + String.valueOf(serviceOptions != null ? serviceOptions : ""));
                event.setChannelDescriptor(apco25Channel);
                this.broadcast(event);
                SourceConfigTuner sourceConfig = new SourceConfigTuner();
                sourceConfig.setFrequency(frequency);
                trafficChannel.setSourceConfiguration(sourceConfig);
                this.mAllocatedTrafficChannelMap.put(frequency, trafficChannel);
                if (this.mPhase2ScrambleParameters != null) {
                    DecodeConfigP25Phase2 decodeConfig = (DecodeConfigP25Phase2)trafficChannel.getDecodeConfiguration();
                    decodeConfig.setScrambleParameters(this.mPhase2ScrambleParameters.copy());
                }
                ChannelStartProcessingRequest startChannelRequest = new ChannelStartProcessingRequest(trafficChannel, apco25Channel, identifierCollection);
                startChannelRequest.addPreloadDataContent(new PatchGroupPreLoadDataContent(identifierCollection));
                this.getInterModuleEventBus().post((Object)startChannelRequest);
            }
            return;
        }
        if (this.mIgnoreDataCalls && opcode.isDataChannelGrant()) {
            P25ChannelGrantEvent channelGrantEvent = P25ChannelGrantEvent.builder(decodeEventType, timestamp, serviceOptions).channel(apco25Channel).details("PHASE 2 DATA CALL IGNORED: " + String.valueOf(serviceOptions != null ? serviceOptions : "")).identifiers(identifierCollection).build();
            this.mTS0ChannelGrantEventMap.put(frequency, channelGrantEvent);
            this.broadcast(channelGrantEvent);
            return;
        }
        P25ChannelGrantEvent channelGrantEvent = P25ChannelGrantEvent.builder(decodeEventType, timestamp, serviceOptions).channel(apco25Channel).details("PHASE 2 CHANNEL GRANT " + String.valueOf(serviceOptions != null ? serviceOptions : "")).identifiers(identifierCollection).build();
        if (timeslot == 0) {
            this.mTS0ChannelGrantEventMap.put(frequency, channelGrantEvent);
        } else {
            this.mTS1ChannelGrantEventMap.put(frequency, channelGrantEvent);
        }
        if (!this.mAllocatedTrafficChannelMap.containsKey(apco25Channel.getDownlinkFrequency())) {
            Channel trafficChannel = this.mAvailablePhase2TrafficChannelQueue.poll();
            if (trafficChannel == null) {
                channelGrantEvent.setDetails("MAX TRAFFIC CHANNELS EXCEEDED - IGNORED");
                return;
            }
            SourceConfigTuner sourceConfig = new SourceConfigTuner();
            sourceConfig.setFrequency(frequency);
            trafficChannel.setSourceConfiguration(sourceConfig);
            this.mAllocatedTrafficChannelMap.put(frequency, trafficChannel);
            ChannelStartProcessingRequest startChannelRequest = new ChannelStartProcessingRequest(trafficChannel, apco25Channel, identifierCollection);
            startChannelRequest.addPreloadDataContent(new PatchGroupPreLoadDataContent(identifierCollection));
            this.getInterModuleEventBus().post((Object)startChannelRequest);
        }
        this.broadcast(channelGrantEvent);
    }

    private DecodeEventType getEventType(Opcode opcode, ServiceOptions serviceOptions) {
        boolean encrypted = serviceOptions != null ? serviceOptions.isEncrypted() : false;
        DecodeEventType type = null;
        switch (opcode) {
            case OSP_GROUP_VOICE_CHANNEL_GRANT: 
            case OSP_GROUP_VOICE_CHANNEL_GRANT_UPDATE: 
            case OSP_GROUP_VOICE_CHANNEL_GRANT_UPDATE_EXPLICIT: {
                type = encrypted ? DecodeEventType.CALL_GROUP_ENCRYPTED : DecodeEventType.CALL_GROUP;
                break;
            }
            case OSP_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT: 
            case OSP_UNIT_TO_UNIT_VOICE_CHANNEL_GRANT_UPDATE: {
                type = encrypted ? DecodeEventType.CALL_UNIT_TO_UNIT_ENCRYPTED : DecodeEventType.CALL_UNIT_TO_UNIT;
                break;
            }
            case OSP_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_GRANT: 
            case OSP_TELEPHONE_INTERCONNECT_VOICE_CHANNEL_GRANT_UPDATE: {
                type = encrypted ? DecodeEventType.CALL_INTERCONNECT_ENCRYPTED : DecodeEventType.CALL_INTERCONNECT;
                break;
            }
            case OSP_SNDCP_DATA_CHANNEL_GRANT: 
            case OSP_GROUP_DATA_CHANNEL_GRANT: 
            case OSP_INDIVIDUAL_DATA_CHANNEL_GRANT: {
                type = encrypted ? DecodeEventType.DATA_CALL_ENCRYPTED : DecodeEventType.DATA_CALL;
                break;
            }
            case MOTOROLA_OSP_PATCH_GROUP_CHANNEL_GRANT: 
            case MOTOROLA_OSP_PATCH_GROUP_CHANNEL_GRANT_UPDATE: {
                DecodeEventType decodeEventType = type = encrypted ? DecodeEventType.CALL_PATCH_GROUP_ENCRYPTED : DecodeEventType.CALL_PATCH_GROUP;
            }
        }
        if (type == null) {
            mLog.error("Unrecognized opcode for determining decode event type: " + opcode.name());
            type = DecodeEventType.CALL;
        }
        return type;
    }

    @Override
    public Listener<ChannelEvent> getChannelEventListener() {
        return this.mTrafficChannelTeardownMonitor;
    }

    private void broadcast(ChannelEvent channelEvent) {
        if (this.mChannelEventListener != null) {
            this.mChannelEventListener.receive(channelEvent);
        }
    }

    @Override
    public void setChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventListener = listener;
    }

    @Override
    public void removeChannelEventListener() {
        this.mChannelEventListener = null;
    }

    private boolean isSameCall(IdentifierCollection collection1, IdentifierCollection collection2) {
        Identifier toIdentifier1 = this.getIdentifier(collection1, Role.TO);
        Identifier toIdentifier2 = this.getIdentifier(collection2, Role.TO);
        return Objects.equals(toIdentifier1, toIdentifier2);
    }

    private Identifier getIdentifier(IdentifierCollection collection, Role role) {
        List<Identifier> identifiers = collection.getIdentifiers(role);
        if (identifiers.size() >= 1) {
            return identifiers.get(0);
        }
        return null;
    }

    @Override
    public void addDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = listener;
    }

    @Override
    public void removeDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.mAvailablePhase1TrafficChannelQueue.clear();
        this.mAvailablePhase2TrafficChannelQueue.clear();
        ArrayList<Channel> channels = new ArrayList<Channel>(this.mAllocatedTrafficChannelMap.values());
        for (Channel channel : channels) {
            mLog.info("Stopping traffic channel: " + String.valueOf(channel));
            this.broadcast(new ChannelEvent(channel, ChannelEvent.Event.REQUEST_DISABLE));
        }
        this.mTS0ChannelGrantEventMap.clear();
        this.mTS1ChannelGrantEventMap.clear();
    }

    @Override
    public Listener<IMessage> getMessageListener() {
        if (this.mMessageListener == null) {
            this.mMessageListener = message -> {
                if (this.mPhase2ScrambleParameters == null && message.isValid()) {
                    if (message instanceof NetworkStatusBroadcast) {
                        this.mPhase2ScrambleParameters = ((NetworkStatusBroadcast)message).getScrambleParameters();
                    } else if (message instanceof AMBTCNetworkStatusBroadcast) {
                        this.mPhase2ScrambleParameters = ((AMBTCNetworkStatusBroadcast)message).getScrambleParameters();
                    }
                }
            };
        }
        return this.mMessageListener;
    }

    private static APCO25Channel convertPhase2ToPhase1(APCO25Channel channel) {
        P25Channel toConvert = (P25Channel)channel.getValue();
        if (toConvert instanceof P25P2ExplicitChannel) {
            P25P2ExplicitChannel phase2 = (P25P2ExplicitChannel)toConvert;
            return APCO25ExplicitChannel.create(phase2.getDownlinkBandIdentifier(), phase2.getDownlinkChannelNumber(), phase2.getUplinkBandIdentifier(), phase2.getUplinkChannelNumber());
        }
        if (toConvert instanceof P25P2Channel) {
            P25P2Channel phase2 = (P25P2Channel)toConvert;
            return APCO25Channel.create(phase2.getDownlinkBandIdentifier(), phase2.getDownlinkChannelNumber());
        }
        return channel;
    }

    public class TrafficChannelTeardownMonitor
    implements Listener<ChannelEvent> {
        private void resetTrafficChannel(Channel channel, long frequency, boolean isPhase1) {
            P25TrafficChannelManager.this.mAllocatedTrafficChannelMap.remove(frequency);
            if (isPhase1) {
                P25TrafficChannelManager.this.mAvailablePhase1TrafficChannelQueue.add(channel);
            } else {
                P25TrafficChannelManager.this.mAvailablePhase2TrafficChannelQueue.add(channel);
            }
        }

        @Override
        public synchronized void receive(ChannelEvent channelEvent) {
            Channel channel = channelEvent.getChannel();
            if (channel.isTrafficChannel()) {
                boolean isPhase1;
                boolean bl = isPhase1 = channel.getDecodeConfiguration().getDecoderType() == DecoderType.P25_PHASE1;
                if (isPhase1 ? P25TrafficChannelManager.this.mManagedPhase1TrafficChannels.contains(channel) : P25TrafficChannelManager.this.mManagedPhase2TrafficChannels.contains(channel)) {
                    switch (channelEvent.getEvent()) {
                        case NOTIFICATION_PROCESSING_STOP: {
                            P25TrafficChannelManager.this.mAllocatedTrafficChannelMap.entrySet().stream().filter(entry -> entry.getValue() == channel).map(Map.Entry::getKey).findFirst().ifPresent(frequencyToRemove -> {
                                this.resetTrafficChannel(channel, (long)frequencyToRemove, isPhase1);
                                P25TrafficChannelManager.this.mTS0ChannelGrantEventMap.remove(frequencyToRemove);
                                P25TrafficChannelManager.this.mTS1ChannelGrantEventMap.remove(frequencyToRemove);
                            });
                            break;
                        }
                        case NOTIFICATION_PROCESSING_START_REJECTED: {
                            P25TrafficChannelManager.this.mAllocatedTrafficChannelMap.entrySet().stream().filter(entry -> entry.getValue() == channel).map(Map.Entry::getKey).findFirst().ifPresent(rejectedFrequency -> {
                                this.resetTrafficChannel(channel, (long)rejectedFrequency, isPhase1);
                                P25ChannelGrantEvent event = P25TrafficChannelManager.this.mTS0ChannelGrantEventMap.remove(rejectedFrequency);
                                if (event == null) {
                                    event = P25TrafficChannelManager.this.mTS1ChannelGrantEventMap.remove(rejectedFrequency);
                                }
                                if (event != null) {
                                    event.setDetails("CHANNEL START REJECTED - " + event.getDetails());
                                    P25TrafficChannelManager.this.broadcast(event);
                                }
                            });
                        }
                    }
                }
            }
        }
    }
}

