/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.nbfm;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.analog.DecodeConfigAnalog;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;

public class DecodeConfigNBFM
extends DecodeConfigAnalog {
    private boolean mAudioFilter = true;

    @Override
    @JacksonXmlProperty(isAttribute=true, localName="type", namespace="http://www.w3.org/2001/XMLSchema-instance")
    public DecoderType getDecoderType() {
        return DecoderType.NBFM;
    }

    @Override
    protected DecodeConfigAnalog.Bandwidth getDefaultBandwidth() {
        return DecodeConfigAnalog.Bandwidth.BW_12_5;
    }

    @Override
    @JsonIgnore
    public ChannelSpecification getChannelSpecification() {
        switch (this.getBandwidth()) {
            case BW_7_5: {
                return new ChannelSpecification(25000.0, 7500, 3500.0, 3750.0);
            }
            case BW_12_5: {
                return new ChannelSpecification(25000.0, 12500, 6000.0, 7000.0);
            }
            case BW_25_0: {
                return new ChannelSpecification(50000.0, 25000, 12500.0, 13500.0);
            }
        }
        throw new IllegalArgumentException("Unrecognized FM bandwidth value: " + String.valueOf((Object)this.getBandwidth()));
    }

    @JacksonXmlProperty(isAttribute=true, localName="audioFilter")
    public boolean isAudioFilter() {
        return this.mAudioFilter;
    }

    public void setAudioFilter(boolean audioFilter) {
        this.mAudioFilter = audioFilter;
    }
}

