/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327;

import io.github.dsheirer.controller.channel.Channel;
import io.github.dsheirer.controller.channel.ChannelEvent;
import io.github.dsheirer.controller.channel.IChannelEventListener;
import io.github.dsheirer.controller.channel.IChannelEventProvider;
import io.github.dsheirer.controller.channel.event.ChannelStartProcessingRequest;
import io.github.dsheirer.controller.channel.map.ChannelMap;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.module.decode.config.DecodeConfiguration;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.IDecodeEventProvider;
import io.github.dsheirer.module.decode.mpt1327.DecodeConfigMPT1327;
import io.github.dsheirer.module.decode.mpt1327.MPT1327ChannelGrantEvent;
import io.github.dsheirer.module.decode.mpt1327.MPT1327Message;
import io.github.dsheirer.module.decode.mpt1327.channel.MPT1327Channel;
import io.github.dsheirer.module.decode.traffic.TrafficChannelManager;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.config.SourceConfigTuner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPT1327TrafficChannelManager
extends TrafficChannelManager
implements IDecodeEventProvider,
IChannelEventListener,
IChannelEventProvider {
    private static final Logger mLog = LoggerFactory.getLogger(MPT1327TrafficChannelManager.class);
    public static final String CHANNEL_START_REJECTED = "CHANNEL START REJECTED";
    public static final String MAX_TRAFFIC_CHANNELS_EXCEEDED = "MAX TRAFFIC CHANNELS EXCEEDED";
    private Queue<Channel> mAvailableTrafficChannelQueue = new ConcurrentLinkedQueue<Channel>();
    private List<Channel> mManagedTrafficChannels;
    private Map<MPT1327Channel, Channel> mAllocatedTrafficChannelMap = new ConcurrentHashMap<MPT1327Channel, Channel>();
    private Map<MPT1327Channel, MPT1327ChannelGrantEvent> mChannelGrantEventMap = new ConcurrentHashMap<MPT1327Channel, MPT1327ChannelGrantEvent>();
    private TrafficChannelTeardownMonitor mTrafficChannelTeardownMonitor = new TrafficChannelTeardownMonitor();
    private Listener<ChannelEvent> mChannelEventListener;
    private Listener<IDecodeEvent> mDecodeEventListener;
    private ChannelMap mChannelMap;

    public MPT1327TrafficChannelManager(Channel parentChannel, ChannelMap channelMap) {
        this.createTrafficChannels(parentChannel);
        this.mChannelMap = channelMap;
    }

    public void processChannelGrant(MPT1327Message mpt1327Message, IdentifierCollection identifierCollection) {
        if (mpt1327Message.getMessageType() == MPT1327Message.MPTMessageType.GTC) {
            MPT1327Channel mpt1327Channel = MPT1327Channel.create(mpt1327Message.getChannel());
            mpt1327Channel.setChannelMap(this.mChannelMap);
            MPT1327ChannelGrantEvent event = this.mChannelGrantEventMap.get(mpt1327Channel);
            if (event != null) {
                if (this.isSameTalkgroup(identifierCollection, event.getIdentifierCollection())) {
                    event.end(mpt1327Message.getTimestamp());
                    return;
                }
                if (this.mAllocatedTrafficChannelMap.containsKey(mpt1327Channel)) {
                    Channel trafficChannel = this.mAllocatedTrafficChannelMap.get(mpt1327Channel);
                    this.broadcast(new ChannelEvent(trafficChannel, ChannelEvent.Event.REQUEST_DISABLE));
                }
            }
            MPT1327ChannelGrantEvent channelGrantEvent = MPT1327ChannelGrantEvent.mpt1327Builder(DecodeEventType.CALL, mpt1327Message.getTimestamp()).channel(mpt1327Channel).details("Traffic Channel Grant").identifiers(identifierCollection).build();
            this.mChannelGrantEventMap.put(mpt1327Channel, channelGrantEvent);
            if (mpt1327Channel.getDownlinkFrequency() == 0L) {
                channelGrantEvent.setDetails("Invalid Channel Map - No Frequency For Channel " + mpt1327Channel.getChannelNumber());
            } else {
                Channel trafficChannel = this.mAvailableTrafficChannelQueue.poll();
                if (trafficChannel == null) {
                    channelGrantEvent.setDetails(MAX_TRAFFIC_CHANNELS_EXCEEDED);
                    channelGrantEvent.setDetails("Detect:" + channelGrantEvent.getDetails());
                    return;
                }
                SourceConfigTuner sourceConfig = new SourceConfigTuner();
                sourceConfig.setFrequency(mpt1327Channel.getDownlinkFrequency());
                trafficChannel.setSourceConfiguration(sourceConfig);
                this.mAllocatedTrafficChannelMap.put(mpt1327Channel, trafficChannel);
                this.getInterModuleEventBus().post((Object)new ChannelStartProcessingRequest(trafficChannel, mpt1327Channel, identifierCollection));
            }
            this.broadcast(channelGrantEvent);
        }
    }

    private void createTrafficChannels(Channel parentChannel) {
        DecodeConfiguration decodeConfiguration = parentChannel.getDecodeConfiguration();
        ArrayList<Channel> trafficChannelList = new ArrayList<Channel>();
        if (decodeConfiguration instanceof DecodeConfigMPT1327) {
            DecodeConfigMPT1327 decodeConfigMPT1327 = (DecodeConfigMPT1327)decodeConfiguration;
            int maxTrafficChannels = decodeConfigMPT1327.getTrafficChannelPoolSize();
            for (int x = 0; x < maxTrafficChannels; ++x) {
                Channel trafficChannel = new Channel("T-" + parentChannel.getName(), Channel.ChannelType.TRAFFIC);
                trafficChannel.setAliasListName(parentChannel.getAliasListName());
                trafficChannel.setSystem(parentChannel.getSystem());
                trafficChannel.setSite(parentChannel.getSite());
                trafficChannel.setDecodeConfiguration(decodeConfigMPT1327);
                trafficChannel.setEventLogConfiguration(parentChannel.getEventLogConfiguration());
                trafficChannel.setRecordConfiguration(parentChannel.getRecordConfiguration());
                trafficChannelList.add(trafficChannel);
            }
        }
        this.mAvailableTrafficChannelQueue.addAll(trafficChannelList);
        this.mManagedTrafficChannels = Collections.unmodifiableList(trafficChannelList);
    }

    public void broadcast(DecodeEvent decodeEvent) {
        if (this.mDecodeEventListener != null) {
            this.mDecodeEventListener.receive(decodeEvent);
        }
    }

    @Override
    public Listener<ChannelEvent> getChannelEventListener() {
        return this.mTrafficChannelTeardownMonitor;
    }

    private void broadcast(ChannelEvent channelEvent) {
        if (this.mChannelEventListener != null) {
            this.mChannelEventListener.receive(channelEvent);
        }
    }

    @Override
    public void setChannelEventListener(Listener<ChannelEvent> listener) {
        this.mChannelEventListener = listener;
    }

    @Override
    public void removeChannelEventListener() {
        this.mChannelEventListener = null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
        this.mAvailableTrafficChannelQueue.clear();
        ArrayList<Channel> channels = new ArrayList<Channel>(this.mAllocatedTrafficChannelMap.values());
        for (Channel channel : channels) {
            mLog.debug("Stopping traffic channel: " + String.valueOf(channel));
            this.broadcast(new ChannelEvent(channel, ChannelEvent.Event.REQUEST_DISABLE));
        }
    }

    private boolean isSameTalkgroup(IdentifierCollection collection1, IdentifierCollection collection2) {
        Identifier toIdentifier1 = this.getToIdentifier(collection1);
        Identifier toIdentifier2 = this.getToIdentifier(collection2);
        return Objects.equals(toIdentifier1, toIdentifier2);
    }

    private Identifier getToIdentifier(IdentifierCollection collection) {
        List<Identifier> identifiers = collection.getIdentifiers(Role.TO);
        if (identifiers.size() >= 1) {
            return identifiers.get(0);
        }
        return null;
    }

    @Override
    public void addDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = listener;
    }

    @Override
    public void removeDecodeEventListener(Listener<IDecodeEvent> listener) {
        this.mDecodeEventListener = null;
    }

    public class TrafficChannelTeardownMonitor
    implements Listener<ChannelEvent> {
        @Override
        public synchronized void receive(ChannelEvent channelEvent) {
            Channel channel = channelEvent.getChannel();
            if (channel.isTrafficChannel() && MPT1327TrafficChannelManager.this.mManagedTrafficChannels.contains(channel)) {
                switch (channelEvent.getEvent()) {
                    case NOTIFICATION_PROCESSING_STOP: {
                        MPT1327Channel toRemove = this.mptChannelForChannel(channel);
                        if (toRemove == null) break;
                        MPT1327TrafficChannelManager.this.mAllocatedTrafficChannelMap.remove(toRemove);
                        MPT1327TrafficChannelManager.this.mAvailableTrafficChannelQueue.add(channel);
                        MPT1327ChannelGrantEvent event = MPT1327TrafficChannelManager.this.mChannelGrantEventMap.remove(toRemove);
                        if (event == null) break;
                        event.end(System.currentTimeMillis());
                        MPT1327TrafficChannelManager.this.broadcast(event);
                        break;
                    }
                    case NOTIFICATION_PROCESSING_START_REJECTED: {
                        MPT1327Channel rejected = this.mptChannelForChannel(channel);
                        if (rejected == null) break;
                        MPT1327TrafficChannelManager.this.mAllocatedTrafficChannelMap.remove(rejected);
                        MPT1327TrafficChannelManager.this.mAvailableTrafficChannelQueue.add(channel);
                        MPT1327ChannelGrantEvent event = MPT1327TrafficChannelManager.this.mChannelGrantEventMap.remove(rejected);
                        if (event == null) break;
                        if (channelEvent.getDescription() != null) {
                            event.setDetails(channelEvent.getDescription() + " - " + event.getDetails());
                        } else {
                            event.setDetails(channelEvent.getDescription() + " - CHANNEL START REJECTED");
                        }
                        MPT1327TrafficChannelManager.this.broadcast(event);
                    }
                }
            }
        }

        private MPT1327Channel mptChannelForChannel(Channel channel) {
            for (Map.Entry<MPT1327Channel, Channel> entry : MPT1327TrafficChannelManager.this.mAllocatedTrafficChannelMap.entrySet()) {
                if (entry.getValue() != channel) continue;
                return entry.getKey();
            }
            return null;
        }
    }
}

