/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.mpt1327.MPT1327Message;
import java.util.function.Function;

public class MPT1327MessageFilter
extends Filter<IMessage, MPT1327Message.MPTMessageType> {
    private final KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public MPT1327MessageFilter() {
        super("MPT1327 Messages");
        for (MPT1327Message.MPTMessageType type : MPT1327Message.MPTMessageType.values()) {
            this.add(new FilterElement<MPT1327Message.MPTMessageType>(type));
        }
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof MPT1327Message && super.canProcess(message);
    }

    @Override
    public Function<IMessage, MPT1327Message.MPTMessageType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, MPT1327Message.MPTMessageType> {
        private KeyExtractor(MPT1327MessageFilter mPT1327MessageFilter) {
        }

        @Override
        public MPT1327Message.MPTMessageType apply(IMessage message) {
            if (message instanceof MPT1327Message) {
                MPT1327Message mpt = (MPT1327Message)message;
                return mpt.getMessageType();
            }
            return null;
        }
    }
}

