/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mpt1327;

import io.github.dsheirer.bits.IBinarySymbolProcessor;
import io.github.dsheirer.bits.MessageFramer;
import io.github.dsheirer.dsp.afsk.AFSK1200Decoder;
import io.github.dsheirer.dsp.symbol.BinaryToByteBufferAssembler;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.afsk.AbstractAFSKDecoder;
import io.github.dsheirer.module.decode.mpt1327.MPT1327MessageProcessor;
import io.github.dsheirer.module.decode.mpt1327.Sync;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.buffer.IByteBufferProvider;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPT1327Decoder
extends AbstractAFSKDecoder
implements IBinarySymbolProcessor,
IByteBufferProvider {
    private static final Logger mLog = LoggerFactory.getLogger(MPT1327Decoder.class);
    private static final int MESSAGE_LENGTH = 350;
    private MessageFramer mControlMessageFramer;
    private MessageFramer mTrafficMessageFramer;
    private MPT1327MessageProcessor mMessageProcessor;
    private BinaryToByteBufferAssembler mBinaryToByteBufferAssembler = new BinaryToByteBufferAssembler(512);

    protected MPT1327Decoder(AFSK1200Decoder decoder, Sync sync) {
        super(decoder);
        this.init(sync);
    }

    public MPT1327Decoder(Sync sync) {
        super(sync == Sync.NORMAL ? AFSK1200Decoder.Output.NORMAL : AFSK1200Decoder.Output.INVERTED);
        this.init(sync);
    }

    private void init(Sync sync) {
        this.getDecoder().setSymbolProcessor(this);
        this.mControlMessageFramer = new MessageFramer(sync.getControlSyncPattern().getPattern(), 350);
        this.mTrafficMessageFramer = new MessageFramer(sync.getTrafficSyncPattern().getPattern(), 350);
        this.mMessageProcessor = new MPT1327MessageProcessor();
        this.mMessageProcessor.setMessageListener(this.getMessageListener());
        this.mControlMessageFramer.addMessageListener(this.mMessageProcessor);
        this.mTrafficMessageFramer.addMessageListener(this.mMessageProcessor);
    }

    @Override
    public void process(boolean symbol) {
        this.mControlMessageFramer.process(symbol);
        this.mTrafficMessageFramer.process(symbol);
        this.mBinaryToByteBufferAssembler.process(symbol);
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.MPT1327;
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
        super.start();
        this.mControlMessageFramer.reset();
        this.mTrafficMessageFramer.reset();
    }

    public MessageFramer getControlMessageFramer() {
        return this.mControlMessageFramer;
    }

    public MessageFramer getTrafficMessageFramer() {
        return this.mTrafficMessageFramer;
    }

    @Override
    public void setBufferListener(Listener<ByteBuffer> listener) {
        this.mBinaryToByteBufferAssembler.setBufferListener(listener);
    }

    @Override
    public void removeBufferListener(Listener<ByteBuffer> listener) {
        this.mBinaryToByteBufferAssembler.removeBufferListener(listener);
    }

    @Override
    public boolean hasBufferListeners() {
        return this.mBinaryToByteBufferAssembler.hasBufferListeners();
    }
}

