/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.mdc1200;

import io.github.dsheirer.bits.MessageFramer;
import io.github.dsheirer.bits.SyncPattern;
import io.github.dsheirer.dsp.NRZDecoder;
import io.github.dsheirer.dsp.afsk.AFSK1200Decoder;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.afsk.AbstractAFSKDecoder;
import io.github.dsheirer.module.decode.mdc1200.MDCMessageProcessor;

public class MDCDecoder
extends AbstractAFSKDecoder {
    private static final int MESSAGE_LENGTH = 304;
    private NRZDecoder mNRZDecoder;
    private MessageFramer mMessageFramer;
    private MDCMessageProcessor mMessageProcessor;

    public MDCDecoder() {
        super(AFSK1200Decoder.Output.INVERTED);
        this.init();
    }

    protected MDCDecoder(AFSK1200Decoder decoder) {
        super(decoder);
        this.init();
    }

    private void init() {
        this.mNRZDecoder = new NRZDecoder(false);
        this.getDecoder().setSymbolProcessor(this.mNRZDecoder);
        this.mMessageFramer = new MessageFramer(SyncPattern.MDC1200.getPattern(), 304);
        this.mNRZDecoder.setListener(this.mMessageFramer);
        this.mMessageProcessor = new MDCMessageProcessor();
        this.mMessageFramer.addMessageListener(this.mMessageProcessor);
        this.mMessageProcessor.addMessageListener(this.getMessageListener());
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.MDC1200;
    }

    public MessageFramer getMessageFramer() {
        return this.mMessageFramer;
    }
}

