/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrstandard.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.identifier.talkgroup.LTRTalkgroup;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.ltrstandard.LtrStandardMessageType;
import io.github.dsheirer.protocol.Protocol;

public abstract class LTRMessage
extends Message {
    public static final int[] SYNC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    public static final int[] AREA = new int[]{9};
    public static final int[] CHANNEL = new int[]{10, 11, 12, 13, 14};
    public static final int[] HOME_REPEATER = new int[]{15, 16, 17, 18, 19};
    public static final int[] GROUP = new int[]{20, 21, 22, 23, 24, 25, 26, 27};
    public static final int[] FREE = new int[]{28, 29, 30, 31, 32};
    public static final int[] CHECKSUM = new int[]{33, 34, 35, 36, 37, 38, 39};
    private CorrectedBinaryMessage mMessage;
    private MessageDirection mMessageDirection;
    private CRC mCRC;
    private LTRTalkgroup mTalkgroup;

    public LTRMessage(CorrectedBinaryMessage message, MessageDirection direction, CRC crc) {
        this.mMessage = message;
        this.mMessageDirection = direction;
        this.mCRC = crc;
    }

    public abstract LtrStandardMessageType getMessageType();

    @Override
    public boolean isValid() {
        return this.mCRC.passes();
    }

    public CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public CRC getCRC() {
        return this.mCRC;
    }

    public int getArea() {
        return this.mMessage.getInt(AREA);
    }

    public int getChannel() {
        return this.mMessage.getInt(CHANNEL);
    }

    public int getHomeRepeater() {
        return this.mMessage.getInt(HOME_REPEATER);
    }

    public int getGroup() {
        return this.mMessage.getInt(GROUP);
    }

    public int getFree() {
        return this.mMessage.getInt(FREE);
    }

    public LTRTalkgroup getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = LTRTalkgroup.create((this.getArea() << 13) + (this.getHomeRepeater() << 8) + this.getGroup());
        }
        return this.mTalkgroup;
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.LTR;
    }
}

