/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrstandard;

import io.github.dsheirer.filter.Filter;
import io.github.dsheirer.filter.FilterElement;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.ltrstandard.LtrStandardMessageType;
import io.github.dsheirer.module.decode.ltrstandard.message.LTRMessage;
import java.util.function.Function;

public class LTRStandardMessageFilter
extends Filter<IMessage, LtrStandardMessageType> {
    private final KeyExtractor mKeyExtractor = new KeyExtractor(this);

    public LTRStandardMessageFilter() {
        super("LTR Messages");
        for (LtrStandardMessageType type : LtrStandardMessageType.values()) {
            this.add(new FilterElement<LtrStandardMessageType>(type));
        }
    }

    @Override
    public boolean canProcess(IMessage message) {
        return message instanceof LTRMessage && super.canProcess(message);
    }

    @Override
    public Function<IMessage, LtrStandardMessageType> getKeyExtractor() {
        return this.mKeyExtractor;
    }

    private class KeyExtractor
    implements Function<IMessage, LtrStandardMessageType> {
        private KeyExtractor(LTRStandardMessageFilter lTRStandardMessageFilter) {
        }

        @Override
        public LtrStandardMessageType apply(IMessage message) {
            if (message instanceof LTRMessage) {
                LTRMessage ltr = (LTRMessage)message;
                return ltr.getMessageType();
            }
            return null;
        }
    }
}

