/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrstandard;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.FrequencyConfigurationIdentifier;
import io.github.dsheirer.identifier.decoder.DecoderLogicalChannelNameIdentifier;
import io.github.dsheirer.identifier.talkgroup.LTRTalkgroup;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.ltrstandard.LTRStandardDecodeEvent;
import io.github.dsheirer.module.decode.ltrstandard.channel.LtrChannel;
import io.github.dsheirer.module.decode.ltrstandard.message.Call;
import io.github.dsheirer.module.decode.ltrstandard.message.CallEnd;
import io.github.dsheirer.module.decode.ltrstandard.message.Idle;
import io.github.dsheirer.module.decode.ltrstandard.message.LTRMessage;
import io.github.dsheirer.protocol.Protocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRStandardDecoderState
extends DecoderState {
    private static final Logger mLog = LoggerFactory.getLogger(LTRStandardDecoderState.class);
    private Map<Integer, DecodeEvent> mActiveCalls = new HashMap<Integer, DecodeEvent>();
    private Set<LTRTalkgroup> mTalkgroupsFirstHeard = new HashSet<LTRTalkgroup>();
    private Set<LTRTalkgroup> mTalkgroups = new TreeSet<LTRTalkgroup>();
    private LCNTracker mLCNTracker = new LCNTracker(this);
    private DecodeEvent mCurrentCallEvent;
    private LTRTalkgroup mCurrentTalkgroup;

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.LTR;
    }

    @Override
    public void receive(IMessage message) {
        if (message.isValid() && message instanceof LTRMessage) {
            switch (((LTRMessage)message).getMessageType()) {
                case CALL: {
                    if (!(message instanceof Call)) break;
                    Call start = (Call)message;
                    int channel = start.getChannel();
                    this.setChannelNumber(channel);
                    this.mLCNTracker.processFreeChannel(start.getFree());
                    if (!this.mLCNTracker.isValidChannel(channel) || !this.mLCNTracker.isCurrentChannel(channel)) break;
                    if (this.mCurrentTalkgroup == null || !this.mCurrentTalkgroup.equals(start.getTalkgroup())) {
                        this.mCurrentTalkgroup = start.getTalkgroup();
                        this.getIdentifierCollection().remove(IdentifierClass.USER);
                        this.getIdentifierCollection().update(start.getTalkgroup());
                        this.mCurrentCallEvent = LTRStandardDecodeEvent.builder(DecodeEventType.CALL, start.getTimestamp()).identifiers(this.getIdentifierCollection().copyOf()).channel(this.getCurrentChannel()).build();
                    } else {
                        this.mCurrentCallEvent.update(start.getTimestamp());
                    }
                    this.broadcast(this.mCurrentCallEvent);
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.CALL));
                    break;
                }
                case CALL_END: {
                    if (!(message instanceof CallEnd)) break;
                    CallEnd end = (CallEnd)message;
                    this.mCurrentTalkgroup = null;
                    int repeater = end.getFree();
                    this.setChannelNumber(repeater);
                    if (!this.mLCNTracker.isCurrentChannel(repeater)) break;
                    if (this.mCurrentCallEvent != null) {
                        this.mCurrentCallEvent.end(end.getTimestamp());
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.END, State.IDLE));
                    break;
                }
                case IDLE: {
                    if (!(message instanceof Idle)) break;
                    Idle idle = (Idle)message;
                    this.mCurrentTalkgroup = null;
                    this.mLCNTracker.processCallChannel(idle.getChannel());
                    break;
                }
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.mActiveCalls.clear();
        this.mTalkgroupsFirstHeard.clear();
        this.mTalkgroups.clear();
        this.mLCNTracker.reset();
        this.resetState();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.mActiveCalls.clear();
    }

    public boolean hasChannelNumber() {
        return this.mLCNTracker.getCurrentChannel() != 0;
    }

    public int getChannelNumber() {
        return this.mLCNTracker.getCurrentChannel();
    }

    private void setChannelNumber(int channel) {
        int original = this.mLCNTracker.getCurrentChannel();
        this.mLCNTracker.processCallChannel(channel);
        if (this.mLCNTracker.getCurrentChannel() != original) {
            this.getIdentifierCollection().update(DecoderLogicalChannelNameIdentifier.create(String.valueOf(this.mLCNTracker.getCurrentChannel()), Protocol.LTR));
            LtrChannel ltrChannel = new LtrChannel(this.mLCNTracker.getCurrentChannel());
            Identifier identifier = this.getIdentifierCollection().getIdentifier(IdentifierClass.CONFIGURATION, Form.CHANNEL_FREQUENCY, Role.ANY);
            if (identifier instanceof FrequencyConfigurationIdentifier) {
                ltrChannel.setDownlink((Long)((FrequencyConfigurationIdentifier)identifier).getValue());
            }
            this.setCurrentChannel(ltrChannel);
        }
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
            }
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary\n\n");
        sb.append("Decoder:\tLTR-Standard\n");
        sb.append("Monitored LCN: ");
        if (this.hasChannelNumber()) {
            sb.append(this.getChannelNumber());
        } else {
            sb.append("*Insufficient Data*");
        }
        sb.append("\n");
        sb.append("Active LCNs:\t");
        List<Integer> lcns = this.mLCNTracker.getActiveLCNs();
        if (lcns.size() > 0) {
            sb.append(this.mLCNTracker.getActiveLCNs());
        } else {
            sb.append("*Insufficient Data*");
        }
        sb.append("\n\n");
        sb.append("Talkgroups\n");
        if (this.mTalkgroups.isEmpty()) {
            sb.append("  None\n");
        } else {
            for (LTRTalkgroup talkgroup : this.mTalkgroups) {
                sb.append("  ");
                sb.append(talkgroup.formatted());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public class LCNTracker {
        private static final int DEFAULT_COUNT = 10;
        private int[] mCallLCNCounts;
        private int[] mFreeLCNCounts;
        private int mCallHighestCount;
        private int mFreeHighestCount;
        private int mCurrentLCN;

        public LCNTracker(LTRStandardDecoderState this$0) {
            this.reset();
        }

        public void logStatistics() {
            int x;
            for (x = 1; x <= 20; ++x) {
                mLog.debug("Call " + x + ": " + this.mCallLCNCounts[x]);
            }
            mLog.debug("Call Highest Count: " + this.mCallHighestCount);
            for (x = 1; x <= 20; ++x) {
                mLog.debug("Free " + x + ": " + this.mFreeLCNCounts[x]);
            }
            mLog.debug("Free Highest Count: " + this.mFreeHighestCount);
            mLog.debug("Current LCN: " + this.mCurrentLCN);
        }

        public void reset() {
            this.mCallLCNCounts = new int[21];
            this.mFreeLCNCounts = new int[21];
            this.mCallHighestCount = 3;
            this.mFreeHighestCount = 10;
            this.mCurrentLCN = 0;
        }

        public boolean isCurrentChannel(int channel) {
            if (this.mCurrentLCN == 0) {
                return true;
            }
            return channel == this.mCurrentLCN;
        }

        public int getCurrentChannel() {
            return this.mCurrentLCN;
        }

        public boolean isValidChannel(int channel) {
            if (this.isCurrentChannel(channel)) {
                return true;
            }
            int count = this.mFreeLCNCounts[channel];
            int threshold = (int)((double)this.mFreeHighestCount * 0.2);
            return count >= threshold;
        }

        public void processCallChannel(int channel) {
            if (1 <= channel && channel <= 20) {
                int n = channel;
                this.mCallLCNCounts[n] = this.mCallLCNCounts[n] + 1;
                if (this.mCallLCNCounts[channel] > this.mCallHighestCount) {
                    this.mCallHighestCount = this.mCallLCNCounts[channel];
                    this.mCurrentLCN = channel;
                }
            }
        }

        public void processFreeChannel(int channel) {
            if (1 <= channel && channel <= 20) {
                int n = channel;
                this.mFreeLCNCounts[n] = this.mFreeLCNCounts[n] + 1;
                if (this.mFreeLCNCounts[channel] > this.mFreeHighestCount) {
                    this.mFreeHighestCount = this.mFreeLCNCounts[channel];
                }
            }
        }

        public List<Integer> getActiveLCNs() {
            ArrayList<Integer> active = new ArrayList<Integer>();
            if (this.mFreeHighestCount > 10) {
                for (int x = 1; x <= 20; ++x) {
                    if (this.mCurrentLCN != 0 && this.isCurrentChannel(x)) {
                        active.add(x);
                        continue;
                    }
                    if (!this.isValidChannel(x)) continue;
                    active.add(x);
                }
            }
            return active;
        }
    }
}

