/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrstandard;

import io.github.dsheirer.bits.MessageFramer;
import io.github.dsheirer.bits.SyncPattern;
import io.github.dsheirer.dsp.fsk.LTRDecoder;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.Decoder;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.ltrstandard.LTRStandardMessageProcessor;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.real.IRealBufferListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LTRStandardDecoder
extends Decoder
implements IRealBufferListener,
Listener<float[]> {
    public static final int LTR_STANDARD_MESSAGE_LENGTH = 40;
    private static final Logger mLog = LoggerFactory.getLogger(LTRStandardDecoder.class);
    private LTRDecoder mLTRDecoder = new LTRDecoder();
    private MessageFramer mLTRMessageFramer;
    private LTRStandardMessageProcessor mLTRMessageProcessor;

    public LTRStandardDecoder(MessageDirection direction) {
        this.mLTRMessageFramer = direction == MessageDirection.OSW ? new MessageFramer(SyncPattern.LTR_STANDARD_OSW.getPattern(), 40) : new MessageFramer(SyncPattern.LTR_STANDARD_ISW.getPattern(), 40);
        this.mLTRDecoder.setListener(symbols -> {
            for (boolean symbol : symbols) {
                this.mLTRMessageFramer.process(symbol);
            }
        });
        this.mLTRMessageProcessor = new LTRStandardMessageProcessor(direction);
        this.mLTRMessageFramer.addMessageListener(this.mLTRMessageProcessor);
        this.mLTRMessageProcessor.setMessageListener(message -> this.getMessageListener().receive((IMessage)message));
    }

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.LTR;
    }

    @Override
    public Listener<float[]> getBufferListener() {
        return this.mLTRDecoder;
    }

    @Override
    public void receive(float[] realBuffer) {
        this.mLTRDecoder.receive(realBuffer);
    }

    @Override
    public void reset() {
        this.mLTRMessageFramer.reset();
    }
}

