/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.osw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.osw.LtrNetOswMessage;
import java.util.ArrayList;
import java.util.List;

public class OswCallEnd
extends LtrNetOswMessage {
    private List<Identifier> mIdentifiers;

    public OswCallEnd(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.OSW_CALL_END;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC FAIL: ").append(CRCLTR.getCRCReason(this.mMessage, this.getMessageDirection())).append("] ");
        }
        sb.append("CALL END TALKGROUP:").append(this.getTalkgroup().formatted());
        sb.append(" AREA:").append(OswCallEnd.getArea(this.getMessage()));
        sb.append(" LCN:").append(OswCallEnd.getChannel(this.getMessage()));
        sb.append(" FREE:").append(OswCallEnd.getFree(this.getMessage()));
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    public int getChannel() {
        return OswCallEnd.getChannel(this.getMessage());
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTalkgroup());
        }
        return this.mIdentifiers;
    }
}

