/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.osw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.identifier.NeighborIdentifier;
import io.github.dsheirer.module.decode.ltrnet.message.osw.LtrNetOswMessage;
import java.util.ArrayList;
import java.util.List;

public class NeighborId
extends LtrNetOswMessage {
    private NeighborIdentifier mNeighborIdentifier;
    private List<Identifier> mIdentifiers;

    public NeighborId(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.OSW_NEIGHBOR_ID;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC FAIL: ").append(CRCLTR.getCRCReason(this.mMessage, this.getMessageDirection())).append("] ");
        }
        sb.append("NEIGHBOR:").append(this.getNeighborID());
        sb.append(" RANK:").append(this.getNeighborRank());
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    public NeighborIdentifier getNeighborID() {
        if (this.mNeighborIdentifier == null) {
            this.mNeighborIdentifier = NeighborIdentifier.create(this.getMessage().getInt(23, 32));
        }
        return this.mNeighborIdentifier;
    }

    public int getNeighborRank() {
        return this.getMessage().getInt(15, 18) + 1;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getNeighborID());
        }
        return this.mIdentifiers;
    }
}

