/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message.osw;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.module.decode.ltrnet.message.osw.LtrNetOswMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChannelMapHigh
extends LtrNetOswMessage {
    public ChannelMapHigh(CorrectedBinaryMessage message, long timestamp) {
        super(message, timestamp);
    }

    @Override
    public LtrNetMessageType getLtrNetMessageType() {
        return LtrNetMessageType.OSW_CHANNEL_MAP_HIGH;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isValid()) {
            sb.append("[CRC FAIL: ").append(CRCLTR.getCRCReason(this.mMessage, this.getMessageDirection())).append("] ");
        }
        sb.append("CHANNEL MAP HIGH ").append(this.getChannels());
        sb.append(" MSG:").append(this.getMessage().toString());
        return sb.toString();
    }

    public List<Integer> getChannels() {
        ArrayList<Integer> retVal = new ArrayList<Integer>();
        for (int x = 27; x >= 18; --x) {
            if (!this.getMessage().get(x)) continue;
            retVal.add(38 - x);
        }
        return retVal;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

