/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.ltrnet.message;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.CRC;
import io.github.dsheirer.edac.CRCLTR;
import io.github.dsheirer.identifier.talkgroup.LTRTalkgroup;
import io.github.dsheirer.message.Message;
import io.github.dsheirer.message.MessageDirection;
import io.github.dsheirer.module.decode.ltrnet.LtrNetMessageType;
import io.github.dsheirer.protocol.Protocol;

public abstract class LtrNetMessage
extends Message {
    protected static final int[] SYNC = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    protected static final int[] AREA = new int[]{9};
    protected static final int[] CHANNEL = new int[]{10, 11, 12, 13, 14};
    protected static final int[] HOME_REPEATER = new int[]{15, 16, 17, 18, 19};
    protected static final int[] GROUP = new int[]{20, 21, 22, 23, 24, 25, 26, 27};
    protected static final int[] FREE = new int[]{28, 29, 30, 31, 32};
    protected static final int[] CRC_FIELD = new int[]{33, 34, 35, 36, 37, 38, 39};
    protected static final int[] SIXTEEN_BITS = new int[]{17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32};
    protected CorrectedBinaryMessage mMessage;
    protected CRC mCRC;
    private LTRTalkgroup mTalkgroup;
    private MessageDirection mMessageDirection;

    public LtrNetMessage(CorrectedBinaryMessage message, MessageDirection direction, long timestamp) {
        super(timestamp);
        this.mMessage = message;
        this.mMessageDirection = direction;
        this.mCRC = CRCLTR.check(message, direction);
    }

    public MessageDirection getMessageDirection() {
        return this.mMessageDirection;
    }

    protected CorrectedBinaryMessage getMessage() {
        return this.mMessage;
    }

    public abstract LtrNetMessageType getLtrNetMessageType();

    @Override
    public Protocol getProtocol() {
        return Protocol.LTR_NET;
    }

    public LTRTalkgroup getTalkgroup() {
        if (this.mTalkgroup == null) {
            this.mTalkgroup = LTRTalkgroup.create((LtrNetMessage.getArea(this.getMessage()) << 13) + (LtrNetMessage.getHomeRepeater(this.getMessage()) << 8) + LtrNetMessage.getGroup(this.getMessage()));
        }
        return this.mTalkgroup;
    }

    @Override
    public boolean isValid() {
        return this.mCRC.passes();
    }

    public CRC getCRC() {
        return this.mCRC;
    }

    public static int getArea(CorrectedBinaryMessage message) {
        return message.getInt(AREA);
    }

    public static int getChannel(CorrectedBinaryMessage message) {
        return message.getInt(CHANNEL);
    }

    public static int getHomeRepeater(CorrectedBinaryMessage message) {
        return message.getInt(HOME_REPEATER);
    }

    public static int getGroup(CorrectedBinaryMessage message) {
        return message.getInt(GROUP);
    }

    public static int getFree(CorrectedBinaryMessage message) {
        return message.getInt(FREE);
    }
}

